/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import dojox.cometd.Client;
import java.util.Map;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.buffer.BoundedFifoBuffer;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.ChannelImpl;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.util.MapUtils;

public class AjaxMessageDispatcher
extends AbstractMessageDispatcher {
    protected AbstractBayeux bayeux;
    protected boolean cacheMessages = false;
    protected int messageCacheSize = 500;
    protected Buffer messageCache;
    protected String channel;

    public AjaxMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.cacheMessages = MapUtils.getBoolean((Map)endpoint.getProperties(), (Object)"cacheMessages", (Boolean)false);
        this.messageCacheSize = MapUtils.getInteger((Map)endpoint.getProperties(), (Object)"messageCacheSize", (Integer)500);
        this.channel = endpoint.getEndpointURI().getPath();
    }

    public AbstractBayeux getBayeux() {
        return this.bayeux;
    }

    public void setBayeux(AbstractBayeux bayeux) {
        this.bayeux = bayeux;
    }

    protected void doInitialise() throws InitialisationException {
        if (this.cacheMessages) {
            this.messageCache = new BoundedFifoBuffer(this.messageCacheSize);
        }
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        if (!this.connector.isStarted()) {
            this.logger.warn((Object)("Servlet container has not yet initialised, ignoring event: " + event.getMessage().getPayload()));
            return;
        }
        ChannelImpl chan = this.bayeux.getChannel(this.channel);
        if (chan != null) {
            if (chan.getSubscribers().size() > 0 && this.cacheMessages && !this.messageCache.isEmpty()) {
                while (!this.messageCache.isEmpty()) {
                    for (Client client : chan.getSubscribers()) {
                        this.deliver(client, this.channel, this.messageCache.remove());
                    }
                }
            }
            Object data = event.transformMessage();
            for (Client client : chan.getSubscribers()) {
                this.deliver(client, this.channel, data);
            }
        } else if (this.cacheMessages) {
            Object message = event.transformMessage();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("There are no clients waiting, adding message to cache: " + message));
            }
            this.messageCache.add(message);
        }
    }

    protected void deliver(Client client, String channel, Object data) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Delivering to client id: " + client.getId() + " channel:" + channel));
        }
        client.deliver(client, channel, data, null);
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        this.doDispatch(event);
        return null;
    }

    protected void doDispose() {
        if (this.messageCache != null) {
            this.messageCache.clear();
            this.messageCache = null;
        }
    }
}

