/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import java.util.Map;
import org.mule.api.MessagingException;
import org.mule.api.MuleException;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.PropertyScope;
import org.mule.message.DefaultMuleMessageDTO;
import org.mule.module.json.filters.IsJsonFilter;
import org.mule.module.json.transformers.JsonToObject;
import org.mule.transport.AbstractMessageAdapter;

public class AjaxMessageAdapter
extends AbstractMessageAdapter {
    public static final String PAYLOAD_PARAM = "payload";
    public static final String REPLYTO_PARAM = "replyTo";
    protected transient JsonToObject transformer;
    protected transient IsJsonFilter filter = new IsJsonFilter();
    protected Object payload;

    public AjaxMessageAdapter(Object message) throws MuleException {
        this.init(message);
    }

    public AjaxMessageAdapter(Object message, MessageAdapter template) throws MuleException {
        super(template);
        this.init(message);
    }

    protected void init(Object message) throws MessagingException, TransformerException {
        if (message instanceof Map) {
            Map map = (Map)message;
            Object p = map.remove(PAYLOAD_PARAM);
            if (p != null) {
                if (this.filter.accept(p)) {
                    this.transformer = new JsonToObject();
                    this.transformer.setReturnClass(Map.class);
                    this.payload = this.transformer.transform(p);
                } else {
                    this.payload = p;
                }
            } else {
                throw new IllegalArgumentException("payload parameter not set");
            }
            this.setReplyTo(map.remove(REPLYTO_PARAM));
            if (map.size() > 0) {
                this.addProperties(map, PropertyScope.INVOCATION);
            }
        } else if (this.filter.accept(message)) {
            if (message.toString().indexOf(PAYLOAD_PARAM) > -1) {
                this.transformer = new JsonToObject();
                this.transformer.setReturnClass(DefaultMuleMessageDTO.class);
                DefaultMuleMessageDTO dto = null;
                dto = (DefaultMuleMessageDTO)this.transformer.transform(message);
                this.payload = dto.getPayload();
                dto.addPropertiesTo((MessageAdapter)this);
            } else {
                this.transformer = new JsonToObject();
                this.transformer.setReturnClass(Map.class);
                this.payload = this.transformer.transform(message);
            }
        } else {
            this.payload = message;
        }
    }

    public Object getPayload() {
        return this.payload;
    }
}

