/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax.container;

import javax.servlet.ServletException;
import org.mortbay.cometd.continuation.ContinuationCometdServlet;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.transport.Connector;
import org.mule.transport.ajax.container.AjaxServletConnector;
import org.mule.transport.ajax.i18n.AjaxMessages;
import org.mule.transport.service.TransportFactory;

public class MuleAjaxServlet
extends ContinuationCometdServlet {
    public static final String AJAX_CONNECTOR_NAME_PROPERTY = "org.mule.ajax.connector.name";
    protected AjaxServletConnector connector = null;

    public void init() throws ServletException {
        super.init();
        MuleContext muleContext = (MuleContext)this.getServletContext().getAttribute("mule.context");
        if (muleContext == null) {
            throw new ServletException("Property mule.context not set on ServletContext");
        }
        String servletConnectorName = this.getServletConfig().getInitParameter(AJAX_CONNECTOR_NAME_PROPERTY);
        if (servletConnectorName == null) {
            this.connector = (AjaxServletConnector)new TransportFactory(muleContext).getConnectorByProtocol(this.getConnectorProtocol());
            if (this.connector == null) {
                this.connector = new AjaxServletConnector();
                try {
                    muleContext.getRegistry().registerConnector((Connector)this.connector);
                }
                catch (MuleException e) {
                    throw new ServletException("Failed to register the AjaxServletConnector", (Throwable)e);
                }
            }
        } else {
            this.connector = (AjaxServletConnector)muleContext.getRegistry().lookupConnector(servletConnectorName);
            if (this.connector == null) {
                throw new ServletException(AjaxMessages.noAjaxConnectorWithName(servletConnectorName, AJAX_CONNECTOR_NAME_PROPERTY).toString());
            }
        }
        this.connector.setBayeux(this.getBayeux());
    }

    protected String getConnectorProtocol() {
        return "ajax-servlet";
    }
}

