/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import org.cometd.Bayeux;
import org.cometd.Client;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.BayeuxService;
import org.mule.RequestContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractConnector;
import org.mule.transport.AbstractMessageReceiver;

public class AjaxMessageReceiver
extends AbstractMessageReceiver {
    private AbstractBayeux bayeux;
    private ReceiverService service;

    public AjaxMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
    }

    public AbstractBayeux getBayeux() {
        return this.bayeux;
    }

    public void setBayeux(AbstractBayeux bayeux) {
        this.bayeux = bayeux;
    }

    protected void doStart() throws MuleException {
        this.service = new ReceiverService(this.endpoint.getEndpointURI().getPath(), (Bayeux)this.getBayeux(), (ImmutableEndpoint)this.getEndpoint());
    }

    public class ReceiverService
    extends BayeuxService {
        private final ImmutableEndpoint endpoint;

        public ReceiverService(String channel, Bayeux bayeux, ImmutableEndpoint endpoint) {
            super(bayeux, channel);
            this.endpoint = endpoint;
            this.subscribe(channel, "route");
        }

        public Object route(Client client, Object data) throws Exception {
            AbstractConnector connector = (AbstractConnector)AjaxMessageReceiver.this.getConnector();
            MuleMessage messageToRoute = AjaxMessageReceiver.this.createMuleMessage(data, this.endpoint.getEncoding());
            Object replyTo = messageToRoute.getReplyTo();
            MuleMessage message = AjaxMessageReceiver.this.routeMessage(messageToRoute);
            if (message != null && message.getExceptionPayload() == null && replyTo != null) {
                connector.getReplyToHandler().processReplyTo(RequestContext.getEvent(), message, replyTo);
            }
            return null;
        }
    }
}

