/*
 * $Id: AjaxNamespaceHandlerTestCase.java 20321 2010-11-24 15:21:24Z dfeist $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.transport.ajax;

import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.tck.DynamicPortTestCase;
import org.mule.transport.ajax.container.AjaxServletConnector;
import org.mule.transport.ajax.embedded.AjaxConnector;

import java.net.URL;

public class AjaxNamespaceHandlerTestCase extends DynamicPortTestCase
{
    protected String getConfigResources()
    {
        return "ajax-namespace-config.xml";
    }

    public void testConnector1Properties() throws Exception
    {
        AjaxConnector connector =
                (AjaxConnector) muleContext.getRegistry().lookupConnector("connector1");

        assertNotNull(connector);

        assertTrue(connector.isJsonCommented());
        assertEquals(1000, connector.getInterval());
        assertEquals(1, connector.getLogLevel());
        assertEquals(10000, connector.getMaxInterval());
        assertEquals(3000, connector.getMultiFrameInterval());
        assertEquals(4000, connector.getRefsThreshold());
        assertEquals(50000, connector.getTimeout());
        assertEquals(new URL("http://0.0.0.0:" + getPorts().get(0) + "/service"), connector.getServerUrl());
        assertEquals("/foo/bar", connector.getResourceBase());
    }

    public void testSecureConnector2Properties() throws Exception
    {
        AjaxConnector connector =
                (AjaxConnector) muleContext.getRegistry().lookupConnector("connector2");

        assertNotNull(connector);

        assertTrue(connector.isJsonCommented());
        assertEquals(1000, connector.getInterval());
        assertEquals(1, connector.getLogLevel());
        assertEquals(10000, connector.getMaxInterval());
        assertEquals(3000, connector.getMultiFrameInterval());
        assertEquals(4000, connector.getRefsThreshold());
        assertEquals(50000, connector.getTimeout());
        assertEquals(new URL("https://0.0.0.0:" + getPorts().get(1) + "/service"), connector.getServerUrl());
        assertEquals("/foo/bar", connector.getResourceBase());

        //The full path gets resolved, we're just checkng that the property got set
        assertTrue(connector.getKeyStore().endsWith("/serverKeystore"));
        assertEquals("mulepassword", connector.getKeyPassword());
        assertEquals("mulepassword", connector.getKeyStorePassword());
        //The full path gets resolved, we're just checkng that the property got set
        assertTrue(connector.getClientKeyStore().endsWith("/clientKeystore"));
        assertEquals("mulepassword", connector.getClientKeyStorePassword());
        //The full path gets resolved, we're just checkng that the property got set
        assertTrue(connector.getTrustStore().endsWith("/trustStore"));
        assertEquals("mulepassword", connector.getTrustStorePassword());
        assertTrue(connector.isExplicitTrustStoreOnly());
        assertTrue(connector.isRequireClientAuthentication());
    }

    public void testAjaxServletConnector() throws Exception
    {
        AjaxServletConnector connector = (AjaxServletConnector) muleContext.getRegistry().lookupConnector("connector3");
        assertNotNull(connector);
        //No properties
    }

    public void testEmbeddedEndpoint() throws Exception
    {
        EndpointBuilder b = muleContext.getRegistry().lookupEndpointBuilder("endpoint1");
        assertNotNull(b);
        InboundEndpoint ep = b.buildInboundEndpoint();
        assertEquals("/request", ep.getEndpointURI().getPath());
    }

    public void testServletEndpoint() throws Exception
    {
        EndpointBuilder b = muleContext.getRegistry().lookupEndpointBuilder("endpoint2");
        assertNotNull(b);
        InboundEndpoint ep = b.buildInboundEndpoint();
        assertEquals("/response", ep.getEndpointURI().getPath());
    }

    @Override
    protected int getNumPortsToFind()
    {
        return 2;
    }
}
