/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax.config;

import org.mule.config.spring.handlers.AbstractMuleNamespaceHandler;
import org.mule.config.spring.parsers.MuleDefinitionParserConfiguration;
import org.mule.config.spring.parsers.generic.MuleOrphanDefinitionParser;
import org.mule.config.spring.parsers.specific.endpoint.TransportEndpointDefinitionParser;
import org.mule.config.spring.parsers.specific.endpoint.TransportGlobalEndpointDefinitionParser;
import org.mule.config.spring.parsers.specific.endpoint.support.AddressedEndpointDefinitionParser;
import org.mule.config.spring.parsers.specific.tls.ClientKeyStoreDefinitionParser;
import org.mule.config.spring.parsers.specific.tls.KeyStoreDefinitionParser;
import org.mule.config.spring.parsers.specific.tls.ProtocolHandlerDefinitionParser;
import org.mule.config.spring.parsers.specific.tls.TrustStoreDefinitionParser;
import org.mule.transport.ajax.container.AjaxServletConnector;
import org.mule.transport.ajax.embedded.AjaxConnector;
import org.springframework.beans.factory.xml.BeanDefinitionParser;

public class AjaxNamespaceHandler
extends AbstractMuleNamespaceHandler {
    public void init() {
        MuleDefinitionParserConfiguration mdp = this.registerStandardTransportEndpoints("ajax", new String[]{"channel"});
        mdp.addAlias("channel", "path");
        this.registerConnectorDefinitionParser(AjaxConnector.class);
        this.registerBeanDefinitionParser("key-store", (BeanDefinitionParser)new KeyStoreDefinitionParser());
        this.registerBeanDefinitionParser("client", (BeanDefinitionParser)new ClientKeyStoreDefinitionParser());
        this.registerBeanDefinitionParser("server", (BeanDefinitionParser)new TrustStoreDefinitionParser());
        this.registerBeanDefinitionParser("protocol-handler", (BeanDefinitionParser)new ProtocolHandlerDefinitionParser());
        this.registerBeanDefinitionParser("servlet-connector", (BeanDefinitionParser)new MuleOrphanDefinitionParser(AjaxServletConnector.class, true));
        this.registerBeanDefinitionParser("servlet-endpoint", (BeanDefinitionParser)this.createServletGlobalEndpointParser(this.getGlobalEndpointBuilderBeanClass()));
        this.registerBeanDefinitionParser("servlet-inbound-endpoint", (BeanDefinitionParser)this.createServletEndpointParser(this.getInboundEndpointFactoryBeanClass()));
        this.registerBeanDefinitionParser("servlet-outbound-endpoint", (BeanDefinitionParser)this.createServletEndpointParser(this.getOutboundEndpointFactoryBeanClass()));
    }

    protected AddressedEndpointDefinitionParser createServletEndpointParser(Class factoryBean) {
        TransportEndpointDefinitionParser parser = new TransportEndpointDefinitionParser("ajax-servlet", false, factoryBean, new String[]{"channel"}, new String[0]);
        parser.addAlias("channel", "path");
        return parser;
    }

    protected AddressedEndpointDefinitionParser createServletGlobalEndpointParser(Class factoryBean) {
        TransportGlobalEndpointDefinitionParser parser = new TransportGlobalEndpointDefinitionParser("ajax-servlet", false, factoryBean, new String[]{"channel"}, new String[0]);
        parser.addAlias("channel", "path");
        return parser;
    }
}

