/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import java.io.IOException;
import java.util.Map;
import org.mule.DefaultMuleMessage;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.transport.PropertyScope;
import org.mule.module.json.JsonData;
import org.mule.module.json.filters.IsJsonFilter;
import org.mule.transport.AbstractMuleMessageFactory;

public class AjaxMuleMessageFactory
extends AbstractMuleMessageFactory {
    protected transient IsJsonFilter filter = new IsJsonFilter();

    public AjaxMuleMessageFactory(MuleContext context) {
        super(context);
    }

    protected Class<?>[] getSupportedTransportMessageTypes() {
        return new Class[]{Object.class};
    }

    protected Object extractPayload(Object transportMessage, String encoding) throws Exception {
        if (transportMessage instanceof Map) {
            return this.extractPayloadFromMap((Map)transportMessage);
        }
        if (this.filter.accept(transportMessage)) {
            return this.extractJsonPayload(transportMessage);
        }
        return transportMessage;
    }

    protected void addProperties(DefaultMuleMessage muleMessage, Object transportMessage) throws Exception {
        if (transportMessage instanceof Map) {
            this.addPropertiesFromMap(muleMessage, (Map)transportMessage);
        } else if (this.filter.accept(transportMessage)) {
            this.addPropertiesToFromJsonData(muleMessage, transportMessage);
        }
    }

    private Object extractPayloadFromMap(Map<?, ?> map) {
        Object data = map.remove("data");
        if (data == null) {
            throw new IllegalArgumentException("data parameter not set in payload map");
        }
        return data;
    }

    private Object extractJsonPayload(Object transportMessage) throws DefaultMuleException {
        String transportMessageString = transportMessage.toString();
        if (transportMessageString.indexOf("data") > -1) {
            try {
                JsonData data = new JsonData(transportMessageString);
                return data.get("data").toString();
            }
            catch (IOException e) {
                throw new DefaultMuleException((Throwable)e);
            }
        }
        return transportMessage;
    }

    private void addPropertiesFromMap(DefaultMuleMessage muleMessage, Map<?, ?> map) {
        Object replyTo = map.remove("replyTo");
        muleMessage.setReplyTo(replyTo);
        map.remove("data");
        Map<?, ?> messageProperties = map;
        muleMessage.addProperties(messageProperties, PropertyScope.INVOCATION);
    }

    private void addPropertiesToFromJsonData(DefaultMuleMessage muleMessage, Object transportMessage) throws IOException {
        JsonData data = new JsonData(transportMessage.toString());
        if (data.hasNode("replyTo")) {
            muleMessage.setReplyTo((Object)data.getAsString("replyTo"));
        }
    }
}

