/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import java.util.List;
import org.cometd.Channel;
import org.cometd.Client;
import org.mortbay.cometd.AbstractBayeux;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.Connector;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.transport.AbstractConnector;
import org.mule.transport.DefaultReplyToHandler;
import org.mule.transport.ajax.BayeuxAware;

public class AjaxReplyToHandler
extends DefaultReplyToHandler {
    private static final long serialVersionUID = 1L;

    public AjaxReplyToHandler(Connector connector) {
        super(connector.getMuleContext());
        this.connector = connector;
    }

    public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
        Object ret;
        AbstractBayeux bayeux = ((BayeuxAware)this.connector).getBayeux();
        Channel channel = bayeux.getChannel(replyTo.toString(), false);
        if (channel == null) {
            this.logger.warn((Object)("No ajax Channel: " + replyTo + ". Maybe the client unregistered interest."));
            return;
        }
        if (returnMessage.getExceptionPayload() != null) {
            ret = returnMessage.getExceptionPayload().getMessage();
        } else {
            EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(event.getMessageSourceURI().toString(), this.muleContext);
            endpointBuilder.setConnector(this.connector);
            OutboundEndpoint tempEndpoint = this.muleContext.getEndpointFactory().getOutboundEndpoint((EndpointBuilder)endpointBuilder);
            List defaultTransportTransformers = ((AbstractConnector)this.connector).getDefaultOutboundTransformers((ImmutableEndpoint)tempEndpoint);
            returnMessage.applyTransformers(event, defaultTransportTransformers);
            ret = returnMessage.getPayload();
        }
        for (Client client : channel.getSubscribers()) {
            channel.publish(client, ret, null);
        }
    }
}

