/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.jackson.map.ObjectMapper;
import org.cometd.Client;
import org.cometd.ClientListener;
import org.cometd.Message;
import org.cometd.MessageListener;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mortbay.cometd.client.BayeuxClient;
import org.mortbay.jetty.client.Address;
import org.mortbay.jetty.client.HttpClient;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.concurrent.Latch;

public class AjaxFunctionalJsonBindingsTestCase
extends AbstractServiceAndFlowTestCase {
    public static int SERVER_PORT = -1;
    private BayeuxClient client;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public AjaxFunctionalJsonBindingsTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "ajax-embedded-functional-json-bindings-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "ajax-embedded-functional-json-bindings-test-flow.xml"});
    }

    protected void doSetUp() throws Exception {
        SERVER_PORT = this.dynamicPort.getNumber();
        HttpClient http = new HttpClient();
        http.setConnectorType(2);
        this.client = new BayeuxClient(http, new Address("localhost", SERVER_PORT), "/ajax/cometd");
        http.start();
        this.client.start();
    }

    protected void doTearDown() throws Exception {
        try {
            this.client.stop();
        }
        catch (IllegalStateException e) {
            this.logger.info((Object)"caught an IllegalStateException during tearDown", (Throwable)e);
        }
        catch (Exception e1) {
            Assert.fail((String)("unexpected exception during tearDown :" + e1.getMessage()));
        }
    }

    @Test
    @Ignore(value="MULE-6926: flaky test")
    public void testClientSubscribeWithJsonObjectResponse() throws Exception {
        final Latch latch = new Latch();
        final AtomicReference data = new AtomicReference();
        this.client.addListener((ClientListener)new MessageListener(){

            public void deliver(Client fromClient, Client toClient, Message message) {
                if (message.getData() != null) {
                    data.set(message.toString());
                    latch.release();
                }
            }
        });
        this.client.subscribe("/test1");
        LocalMuleClient muleClient = muleContext.getClient();
        muleClient.dispatch("vm://in1", (Object)"Ross", null);
        Assert.assertTrue((String)"data did not arrive on time", (boolean)latch.await(60L, TimeUnit.SECONDS));
        Assert.assertNotNull(data.get());
        ObjectMapper mapper = new ObjectMapper();
        Map result = (Map)mapper.readValue((String)data.get(), Map.class);
        Assert.assertEquals((Object)"/test1", result.get("channel"));
        Assert.assertEquals((Object)"Ross", ((Map)result.get("data")).get("name"));
    }

    @Test
    @Ignore(value="MULE-6926: flaky test")
    public void testClientPublishWithJsonObject() throws Exception {
        this.client.publish("/test2", (Object)"{\"name\":\"Ross\"}", null);
        LocalMuleClient muleClient = muleContext.getClient();
        MuleMessage msg = muleClient.request("vm://in2", 5000L);
        Assert.assertNotNull((Object)msg);
        Assert.assertEquals((Object)"Received: DummyJsonBean{name='Ross'}", (Object)msg.getPayloadAsString());
    }
}

