/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.jackson.map.ObjectMapper;
import org.cometd.Client;
import org.cometd.ClientListener;
import org.cometd.Message;
import org.cometd.MessageListener;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mortbay.cometd.client.BayeuxClient;
import org.mortbay.jetty.client.Address;
import org.mortbay.jetty.client.HttpClient;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.util.concurrent.Latch;

public class AjaxFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    public static int SERVER_PORT = -1;
    private HttpClient httpClient;
    private BayeuxClient bayeuxClient;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public AjaxFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setStartContext(false);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "ajax-embedded-functional-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "ajax-embedded-functional-test-flow.xml"});
    }

    protected void doSetUp() throws Exception {
        SERVER_PORT = this.dynamicPort.getNumber();
        this.httpClient = new HttpClient();
        this.httpClient.setConnectorType(2);
        this.httpClient.start();
        this.bayeuxClient = new BayeuxClient(this.httpClient, new Address("localhost", SERVER_PORT), "/ajax/cometd");
        this.bayeuxClient.start();
        Assert.assertTrue((String)"httpClient is not running", (boolean)this.httpClient.isRunning());
        Assert.assertTrue((String)"bayeuxClient is not running", (boolean)this.bayeuxClient.isRunning());
        muleContext.start();
    }

    protected void doTearDown() throws Exception {
        if (muleContext.isStarted()) {
            muleContext.stop();
        }
        if (this.httpClient.isRunning()) {
            this.httpClient.stop();
        }
        try {
            this.bayeuxClient.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Ignore(value="flaky test")
    @Test
    public void testClientSubscribeWithString() throws Exception {
        Thread.sleep(5000L);
        final Latch latch = new Latch();
        final AtomicReference data = new AtomicReference();
        this.bayeuxClient.addListener((ClientListener)new MessageListener(){

            public void deliver(Client fromClient, Client toClient, Message message) {
                if (message.getData() != null) {
                    data.set(message.toString());
                    latch.release();
                }
            }
        });
        this.bayeuxClient.subscribe("/test1");
        LocalMuleClient muleClient = muleContext.getClient();
        muleClient.dispatch("vm://in1", (Object)"Ross", null);
        latch.await(10L, TimeUnit.SECONDS);
        Assert.assertNotNull(data.get());
        ObjectMapper mapper = new ObjectMapper();
        Map result = (Map)mapper.readValue((String)data.get(), Map.class);
        Assert.assertEquals((Object)"/test1", result.get("channel"));
        Assert.assertEquals((Object)"Ross Received", result.get("data"));
    }

    @Test
    @Ignore(value="MULE-6926: flaky test")
    public void testClientPublishWithString() throws Exception {
        LocalMuleClient muleClient = muleContext.getClient();
        this.bayeuxClient.publish("/test2", (Object)"Ross", null);
        final MuleMessage msg = muleClient.request("vm://in2", 10000L);
        PollingProber prober = new PollingProber();
        prober.check(new Probe(){

            public boolean isSatisfied() {
                return msg != null;
            }

            public String describeFailure() {
                return "No message was returned from request";
            }
        });
        Assert.assertNotNull((Object)msg);
        Assert.assertEquals((Object)"Ross Received", (Object)msg.getPayloadAsString());
    }
}

