/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.transport.AbstractMuleMessageFactoryTestCase;
import org.mule.transport.ajax.AjaxMuleMessageFactory;

public class AjaxMuleMessageFactoryTestCase
extends AbstractMuleMessageFactoryTestCase {
    private static final String JSON_STRING = "{\"value1\":\"foo\",\"value2\":\"bar\"}";

    public AjaxMuleMessageFactoryTestCase() {
        this.runUnsuppoprtedTransportMessageTest = false;
    }

    protected MuleMessageFactory doCreateMuleMessageFactory() {
        return new AjaxMuleMessageFactory();
    }

    protected Object getValidTransportMessage() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("data", JSON_STRING);
        map.put("replyTo", "/reply");
        map.put("message-property", "mp-value");
        return map;
    }

    public void testValidPayload() throws Exception {
        MuleMessageFactory factory = this.createMuleMessageFactory();
        Object payload = this.getValidTransportMessage();
        MuleMessage message = factory.create(payload, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)JSON_STRING, (Object)message.getPayload());
        Assert.assertEquals((Object)"/reply", (Object)message.getReplyTo());
        Assert.assertEquals((Object)"mp-value", (Object)message.getInvocationProperty("message-property"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMapPayloadWithoutData() throws Exception {
        Map payload = (Map)this.getValidTransportMessage();
        payload.remove("data");
        MuleMessageFactory factory = this.createMuleMessageFactory();
        factory.create((Object)payload, this.encoding, muleContext);
    }

    @Test
    public void testJsonStringPayloadWithoutData() throws Exception {
        String payload = "{\"value1\" : \"foo\", \"value2\" : \"bar\"}";
        MuleMessageFactory factory = this.createMuleMessageFactory();
        MuleMessage message = factory.create((Object)payload, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)payload, (Object)message.getPayload());
        Assert.assertTrue((boolean)(message.getPayload() instanceof String));
    }

    @Test
    public void testJsonStringWithData() throws Exception {
        String data = JSON_STRING;
        String payload = String.format("{ \"data\" : %1s, \"%2s\" : \"/replyEndpoint\"}", data, "replyTo");
        MuleMessageFactory factory = this.createMuleMessageFactory();
        MuleMessage message = factory.create((Object)payload, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)data, (Object)message.getPayload());
        Assert.assertEquals((Object)"/replyEndpoint", (Object)message.getReplyTo());
    }

    @Test
    public void testNonMapNonJsonPayload() throws Exception {
        FruitBowl payload = new FruitBowl(new Apple(), new Banana());
        MuleMessageFactory factory = this.createMuleMessageFactory();
        MuleMessage message = factory.create((Object)payload, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)payload, (Object)message.getPayload());
    }
}

