/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import java.net.URL;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.ajax.container.AjaxServletConnector;
import org.mule.transport.ajax.embedded.AjaxConnector;

public class AjaxNamespaceHandlerTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    protected String getConfigFile() {
        return "ajax-namespace-config.xml";
    }

    @Test
    public void testConnector1Properties() throws Exception {
        AjaxConnector connector = (AjaxConnector)muleContext.getRegistry().lookupConnector("connector1");
        Assert.assertNotNull((Object)connector);
        Assert.assertTrue((boolean)connector.isJsonCommented());
        Assert.assertEquals((long)1000L, (long)connector.getInterval());
        Assert.assertEquals((long)1L, (long)connector.getLogLevel());
        Assert.assertEquals((long)10000L, (long)connector.getMaxInterval());
        Assert.assertEquals((long)3000L, (long)connector.getMultiFrameInterval());
        Assert.assertEquals((long)4000L, (long)connector.getRefsThreshold());
        Assert.assertEquals((long)50000L, (long)connector.getTimeout());
        Assert.assertEquals((Object)new URL("http://0.0.0.0:" + this.dynamicPort1.getNumber() + "/service"), (Object)connector.getServerUrl());
        Assert.assertEquals((Object)"/foo/bar", (Object)connector.getResourceBase());
        Assert.assertTrue((boolean)connector.isValidateConnections());
    }

    @Test
    public void testSecureConnector2Properties() throws Exception {
        AjaxConnector connector = (AjaxConnector)muleContext.getRegistry().lookupConnector("connector2");
        Assert.assertNotNull((Object)connector);
        Assert.assertTrue((boolean)connector.isJsonCommented());
        Assert.assertEquals((long)1000L, (long)connector.getInterval());
        Assert.assertEquals((long)1L, (long)connector.getLogLevel());
        Assert.assertEquals((long)10000L, (long)connector.getMaxInterval());
        Assert.assertEquals((long)3000L, (long)connector.getMultiFrameInterval());
        Assert.assertEquals((long)4000L, (long)connector.getRefsThreshold());
        Assert.assertEquals((long)50000L, (long)connector.getTimeout());
        Assert.assertEquals((Object)new URL("https://0.0.0.0:" + this.dynamicPort2.getNumber() + "/service"), (Object)connector.getServerUrl());
        Assert.assertEquals((Object)"/foo/bar", (Object)connector.getResourceBase());
        Assert.assertTrue((boolean)connector.getKeyStore().endsWith("/serverKeystore"));
        Assert.assertEquals((Object)"muleserver", (Object)connector.getKeyAlias());
        Assert.assertEquals((Object)"mulepassword", (Object)connector.getKeyPassword());
        Assert.assertEquals((Object)"mulepassword", (Object)connector.getKeyStorePassword());
        Assert.assertTrue((boolean)connector.getClientKeyStore().endsWith("/clientKeystore"));
        Assert.assertEquals((Object)"mulepassword", (Object)connector.getClientKeyStorePassword());
        Assert.assertTrue((boolean)connector.getTrustStore().endsWith("/trustStore"));
        Assert.assertEquals((Object)"mulepassword", (Object)connector.getTrustStorePassword());
        Assert.assertTrue((boolean)connector.isExplicitTrustStoreOnly());
        Assert.assertTrue((boolean)connector.isRequireClientAuthentication());
    }

    @Test
    public void testAjaxServletConnector() throws Exception {
        AjaxServletConnector connector = (AjaxServletConnector)muleContext.getRegistry().lookupConnector("connector3");
        Assert.assertNotNull((Object)connector);
    }

    @Test
    public void testEmbeddedEndpoint() throws Exception {
        EndpointBuilder b = muleContext.getRegistry().lookupEndpointBuilder("endpoint1");
        Assert.assertNotNull((Object)b);
        InboundEndpoint ep = b.buildInboundEndpoint();
        Assert.assertEquals((Object)"/request", (Object)ep.getEndpointURI().getPath());
    }

    @Test
    public void testServletEndpoint() throws Exception {
        EndpointBuilder b = muleContext.getRegistry().lookupEndpointBuilder("endpoint2");
        Assert.assertNotNull((Object)b);
        InboundEndpoint ep = b.buildInboundEndpoint();
        Assert.assertEquals((Object)"/response", (Object)ep.getEndpointURI().getPath());
    }
}

