/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.cometd.Client;
import org.cometd.ClientListener;
import org.cometd.Message;
import org.cometd.MessageListener;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mortbay.cometd.client.BayeuxClient;
import org.mortbay.jetty.client.Address;
import org.mortbay.jetty.client.HttpClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.concurrent.Latch;

public class AjaxRPCFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    public static final String TEST_JSON_MESSAGE = "{\"data\" : {\"value1\" : \"foo\", \"value2\" : \"bar\"}, \"replyTo\" : \"/response\"}";
    public static int SERVER_PORT = -1;
    private BayeuxClient client;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public AjaxRPCFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "ajax-rpc-test.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "ajax-rpc-test-flow.xml"});
    }

    protected void doSetUp() throws Exception {
        SERVER_PORT = this.dynamicPort.getNumber();
        HttpClient http = new HttpClient();
        http.setConnectorType(2);
        this.client = new BayeuxClient(http, new Address("localhost", SERVER_PORT), "/ajax/cometd");
        http.start();
        this.client.start();
    }

    protected void doTearDown() throws Exception {
        this.client.stop();
    }

    @Test
    @Ignore(value="MULE-6926: flaky test")
    public void testDispatchReceiveSimple() throws Exception {
        final Latch latch = new Latch();
        final AtomicReference data = new AtomicReference();
        this.client.addListener((ClientListener)new MessageListener(){

            public void deliver(Client fromClient, Client toClient, Message message) {
                if (message.getData() != null) {
                    data.set(message.getData());
                    latch.release();
                }
            }
        });
        this.client.subscribe("/response");
        this.client.publish("/request", (Object)TEST_JSON_MESSAGE, null);
        latch.await(60L, TimeUnit.SECONDS);
        Assert.assertNotNull(data.get());
        Assert.assertEquals((Object)"{\"value1\":\"foo\",\"value2\":\"bar\"}", data.get());
    }
}

