/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import org.mortbay.cometd.AbstractBayeux;
import org.mule.api.MuleException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.MessageDispatcher;
import org.mule.transport.AbstractMessageDispatcherFactory;
import org.mule.transport.ajax.AjaxMessageDispatcher;
import org.mule.transport.ajax.container.AjaxServletConnector;
import org.mule.transport.ajax.embedded.AjaxConnector;

public class AjaxMessageDispatcherFactory
extends AbstractMessageDispatcherFactory {
    public MessageDispatcher create(OutboundEndpoint endpoint) throws MuleException {
        AjaxMessageDispatcher dispatcher = new AjaxMessageDispatcher(endpoint);
        if (endpoint.getConnector() instanceof AjaxConnector) {
            dispatcher.setBayeux(((AjaxConnector)endpoint.getConnector()).getBayeux());
        } else {
            AbstractBayeux b = ((AjaxServletConnector)endpoint.getConnector()).getBayeux();
            if (b == null) {
                long start = System.currentTimeMillis();
                long timeout = start + (long)endpoint.getResponseTimeout();
                while (start < timeout) {
                    try {
                        Thread.sleep(1000L);
                        b = ((AjaxServletConnector)endpoint.getConnector()).getBayeux();
                        if (b == null) continue;
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                throw new IllegalArgumentException("Bayeux is null: " + endpoint.getConnector() + ". Waited for " + endpoint.getResponseTimeout() + " for object to become availble, this usually caused if the servlet container takes a long time to start up");
            }
            dispatcher.setBayeux(b);
        }
        return dispatcher;
    }
}

