/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax.embedded;

import java.net.URL;
import java.util.EventListener;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.AbstractNetworkConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.continuation.ContinuationCometdServlet;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.ReplyToHandler;
import org.mule.transport.ajax.AjaxMessageReceiver;
import org.mule.transport.ajax.AjaxReplyToHandler;
import org.mule.transport.ajax.BayeuxAware;
import org.mule.transport.ajax.container.MuleAjaxServlet;
import org.mule.transport.ajax.i18n.AjaxMessages;
import org.mule.transport.servlet.JarResourceServlet;
import org.mule.transport.servlet.MuleServletContextListener;
import org.mule.transport.servlet.jetty.JettyHttpsConnector;
import org.mule.util.StringUtils;

public class AjaxConnector
extends JettyHttpsConnector
implements BayeuxAware {
    public static final String PROTOCOL = "ajax";
    public static final String CHANNEL_PROPERTY = "channel";
    public static final String AJAX_PATH_SPEC = "/ajax/*";
    public static final String COMETD_CLIENT = "cometd.client";
    public static final String REPLYTO_PARAM = "replyTo";
    private URL serverUrl;
    private int interval = -1;
    private int maxInterval = -1;
    private int multiFrameInterval = -1;
    private int logLevel = -1;
    private int timeout = -1;
    private boolean jsonCommented = true;
    private String filters;
    private boolean requestAvailable = true;
    private boolean directDeliver = true;
    private int refsThreshold = -1;
    private boolean disableReplyTo = false;
    private ContinuationCometdServlet servlet;

    public AjaxConnector(MuleContext context) {
        super(context);
        this.unregisterSupportedProtocol("http");
        this.unregisterSupportedProtocol("https");
        this.unregisterSupportedProtocol("jetty-ssl");
        this.unregisterSupportedProtocol("jetty");
        this.setInitialStateStopped(true);
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public URL getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(URL serverUrl) {
        this.serverUrl = serverUrl;
    }

    protected void doInitialise() throws InitialisationException {
        if (this.serverUrl == null) {
            throw new InitialisationException(AjaxMessages.serverUrlNotDefined(), (Initialisable)this);
        }
        super.doInitialise();
        try {
            this.createEmbeddedServer();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void doStart() throws MuleException {
        super.doStart();
        for (MessageReceiver receiver : this.receivers.values()) {
            ((AjaxMessageReceiver)receiver).setBayeux(this.getBayeux());
        }
    }

    protected void validateSslConfig() throws InitialisationException {
        if (this.serverUrl.getProtocol().equals("https")) {
            super.validateSslConfig();
        }
    }

    public ReplyToHandler getReplyToHandler(ImmutableEndpoint endpoint) {
        return new AjaxReplyToHandler((org.mule.api.transport.Connector)this, endpoint.getMuleContext());
    }

    void createEmbeddedServer() throws MuleException {
        AbstractNetworkConnector connector = this.createJettyConnector();
        this.configureConnector(connector, this.serverUrl.getHost(), this.serverUrl.getPort());
        this.getHttpServer().addConnector((Connector)connector);
        EndpointBuilder builder = this.muleContext.getEndpointFactory().getEndpointBuilder(this.serverUrl.toString());
        this.servlet = (ContinuationCometdServlet)this.createServlet(connector, (ImmutableEndpoint)builder.buildInboundEndpoint());
    }

    public Servlet createServlet(AbstractNetworkConnector connector, ImmutableEndpoint endpoint) {
        MuleAjaxServlet ajaxServlet = new MuleAjaxServlet();
        String path = endpoint.getEndpointURI().getPath();
        if (StringUtils.isBlank((String)path)) {
            path = "/";
        }
        ContextHandlerCollection handlerCollection = new ContextHandlerCollection();
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)handlerCollection, "/", 0);
        root.setVirtualHosts(new String[]{this.getVirtualHostName(connector)});
        root.addEventListener((EventListener)new MuleServletContextListener(this.muleContext, this.getName()));
        if (!"/".equals(path)) {
            ServletContextHandler resourceContext = new ServletContextHandler((HandlerContainer)handlerCollection, path, 0);
            this.populateContext(resourceContext);
        } else {
            this.populateContext(root);
        }
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)ajaxServlet);
        root.addServlet(holder, AJAX_PATH_SPEC);
        if (this.getInterval() != -1) {
            holder.setInitParameter("interval", Integer.toString(this.getInterval()));
        }
        holder.setInitParameter("JSONCommented", Boolean.toString(this.isJsonCommented()));
        if (this.getLogLevel() != -1) {
            holder.setInitParameter("logLevel", Integer.toString(this.getLogLevel()));
        }
        if (this.getMaxInterval() != -1) {
            holder.setInitParameter("maxInterval", Integer.toString(this.getMaxInterval()));
        }
        if (this.getMultiFrameInterval() != -1) {
            holder.setInitParameter("multiFrameInterval", Integer.toString(this.getMultiFrameInterval()));
        }
        if (this.getTimeout() != -1) {
            holder.setInitParameter("timeout", Integer.toString(this.getTimeout()));
        }
        if (this.getRefsThreshold() != -1) {
            holder.setInitParameter("refsThreshold", Integer.toString(this.getRefsThreshold()));
        }
        holder.setInitParameter("requestAvailable", Boolean.toString(this.isRequestAvailable()));
        this.addHandler((Handler)handlerCollection);
        return ajaxServlet;
    }

    protected void populateContext(ServletContextHandler context) {
        context.addServlet(DefaultServlet.class, "/");
        context.addServlet(JarResourceServlet.class, "/mule-resource/*");
        context.addEventListener((EventListener)new MuleServletContextListener(this.muleContext, this.getName()));
        String base = this.getResourceBase();
        if (base != null) {
            context.setResourceBase(base);
        }
    }

    protected AbstractNetworkConnector createJettyConnector() {
        if (this.serverUrl.getProtocol().equals("https")) {
            return super.createJettyConnector();
        }
        ServerConnector serverConnector = new ServerConnector(this.getHttpServer());
        serverConnector.setName(this.getName());
        return serverConnector;
    }

    @Override
    public AbstractBayeux getBayeux() {
        return this.servlet.getBayeux();
    }

    @Override
    public void setBayeux(AbstractBayeux bayeux) {
    }

    protected MessageReceiver createReceiver(FlowConstruct flowConstruct, InboundEndpoint endpoint) throws Exception {
        MessageReceiver receiver = this.getServiceDescriptor().createMessageReceiver((org.mule.api.transport.Connector)this, flowConstruct, endpoint);
        ((AjaxMessageReceiver)receiver).setBayeux(this.getBayeux());
        return receiver;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getMaxInterval() {
        return this.maxInterval;
    }

    public void setMaxInterval(int maxInterval) {
        this.maxInterval = maxInterval;
    }

    public int getMultiFrameInterval() {
        return this.multiFrameInterval;
    }

    public void setMultiFrameInterval(int multiFrameInterval) {
        this.multiFrameInterval = multiFrameInterval;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isJsonCommented() {
        return this.jsonCommented;
    }

    public void setJsonCommented(boolean jsonCommented) {
        this.jsonCommented = jsonCommented;
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public boolean isRequestAvailable() {
        return this.requestAvailable;
    }

    public void setRequestAvailable(boolean requestAvailable) {
        this.requestAvailable = requestAvailable;
    }

    public boolean isDirectDeliver() {
        return this.directDeliver;
    }

    public void setDirectDeliver(boolean directDeliver) {
        this.directDeliver = directDeliver;
    }

    public int getRefsThreshold() {
        return this.refsThreshold;
    }

    public void setRefsThreshold(int refsThreshold) {
        this.refsThreshold = refsThreshold;
    }

    public boolean canHostFullWars() {
        return false;
    }

    public void setDisableReplyTo(boolean disableReplyTo) {
        this.disableReplyTo = disableReplyTo;
    }

    public boolean isDisableReplyTo() {
        return this.disableReplyTo;
    }
}

