/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axis.AxisProperties;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.lang.StringUtils;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.NullPayload;
import org.mule.providers.soap.NamedParameter;
import org.mule.providers.soap.SoapMethod;
import org.mule.providers.soap.axis.AxisConnector;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.BeanUtils;
import org.mule.util.TemplateParser;

public class AxisMessageDispatcher
extends AbstractMessageDispatcher {
    private Map callParameters;
    protected EngineConfiguration clientConfig;
    protected AxisConnector connector;
    protected Service service;
    static /* synthetic */ Class class$java$lang$Object;

    public AxisMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (AxisConnector)endpoint.getConnector();
        AxisProperties.setProperty((String)"axis.doAutoTypes", (String)Boolean.toString(this.connector.isDoAutoTypes()));
    }

    protected void doConnect(UMOImmutableEndpoint endpoint) throws Exception {
        if (this.service == null) {
            this.service = this.createService(endpoint);
        }
    }

    protected void doDisconnect() throws Exception {
        if (this.service != null) {
            this.service = null;
        }
    }

    protected void doDispose() {
    }

    protected EngineConfiguration getClientConfig(UMOImmutableEndpoint endpoint) {
        if (this.clientConfig == null) {
            String config = (String)endpoint.getProperty((Object)"clientConfig");
            this.clientConfig = config != null ? new FileProvider(config) : this.connector.getClientProvider();
        }
        return this.clientConfig;
    }

    protected Service createService(UMOImmutableEndpoint endpoint) throws Exception {
        EngineConfiguration config = this.getClientConfig(endpoint);
        Service service = new Service(config);
        return service;
    }

    protected void doDispatch(UMOEvent event) throws Exception {
        Object[] args = this.getArgs(event);
        Call call = this.getCall(event, args);
        call.setProperty("axis.one.way", (Object)Boolean.TRUE);
        call.setProperty("MULE_EVENT", (Object)event);
        call.invoke(args);
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        Object[] args = this.getArgs(event);
        Call call = this.getCall(event, args);
        Object result = call.invoke(args);
        if (result == null) {
            return null;
        }
        MuleMessage resultMessage = new MuleMessage(result, (UMOMessageAdapter)event.getMessage());
        this.setMessageContextProperties((UMOMessage)resultMessage, call.getMessageContext());
        return resultMessage;
    }

    protected Call getCall(UMOEvent event, Object[] args) throws Exception {
        Map methodCalls;
        UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        Object method = event.getMessage().getProperty("method");
        if (method == null) {
            method = event.getEndpoint().getEndpointURI().getParams().getProperty("method");
        }
        if (method == null) {
            throw new DispatchException(new Message("soap", 4), event.getMessage(), event.getEndpoint());
        }
        if (method instanceof SoapMethod) {
            if (this.callParameters == null) {
                this.callParameters = new HashMap();
            }
            this.callParameters.put(((SoapMethod)method).getName().getLocalPart(), method);
        }
        Call call = (Call)this.service.createCall();
        String style = event.getMessage().getStringProperty("style", null);
        String use = event.getMessage().getStringProperty("use", null);
        if (style != null) {
            Style s = Style.getStyle((String)style);
            if (s == null) {
                throw new IllegalArgumentException(new Message(154, (Object)style, (Object)"style").toString());
            }
            call.setOperationStyle(s);
        }
        if (use != null) {
            Use u = Use.getUse((String)use);
            if (u == null) {
                throw new IllegalArgumentException(new Message(154, (Object)use, (Object)"use").toString());
            }
            call.setOperationUse(u);
        }
        BeanUtils.populateWithoutFail((Object)call, (Map)event.getEndpoint().getProperties(), (boolean)false);
        call.setTargetEndpointAddress(endpointUri.getAddress());
        String methodNamespace = null;
        if (method instanceof String) {
            methodNamespace = (String)event.getMessage().getProperty("methodNamespace");
            if (methodNamespace != null) {
                call.setOperationName(new QName(methodNamespace, method.toString()));
            } else {
                call.setOperationName(new QName(method.toString()));
            }
        } else if (method instanceof QName) {
            call.setOperationName((QName)method);
            method = ((QName)method).getLocalPart();
        } else {
            call.setOperationName(((SoapMethod)method).getName());
        }
        methodNamespace = call.getOperationName().getNamespaceURI();
        call.setProperty("MULE_EVENT", (Object)event);
        call.setProperty("MULE_ENDPOINT", (Object)event.getEndpoint());
        call.setTimeout(new Integer(event.getTimeout()));
        if (endpointUri.getUserInfo() != null) {
            call.setUsername(endpointUri.getUsername());
            call.setPassword(endpointUri.getPassword());
        }
        if ((methodCalls = (Map)event.getMessage().getProperty("soapMethods")) == null && !(method instanceof SoapMethod)) {
            ArrayList<String> params = new ArrayList<String>();
            for (int i = 0; i < args.length; ++i) {
                QName qname;
                if (args[i] == null) {
                    qname = call.getTypeMapping().getTypeQName(class$java$lang$Object == null ? AxisMessageDispatcher.class$("java.lang.Object") : class$java$lang$Object);
                    params.add("value" + i + ";qname{" + qname.getPrefix() + ":" + qname.getLocalPart() + ":" + qname.getNamespaceURI() + "};in");
                    continue;
                }
                if (args[i] instanceof DataHandler[]) {
                    params.add("attachments;qname{DataHandler:http://xml.apache.org/xml-soap};in");
                    continue;
                }
                if (args[i] instanceof Map && this.connector.isTreatMapAsNamedParams()) {
                    Iterator iterator = ((Map)args[i]).entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (call.getTypeMapping().getTypeQName(entry.getValue().getClass()) != null) {
                            QName type = call.getTypeMapping().getTypeQName(entry.getValue().getClass());
                            params.add("qname{" + entry.getKey().toString() + (methodNamespace == null ? "" : ":" + methodNamespace) + "};qname{" + type.getPrefix() + ":" + type.getLocalPart() + ":" + type.getNamespaceURI() + "};in");
                            continue;
                        }
                        params.add("value" + i + ";qname{" + Types.getLocalNameFromFullName((String)args[i].getClass().getName()) + ":" + Namespaces.makeNamespace((String)args[i].getClass().getName()) + "};in");
                        params.add("qname{" + entry.getKey().toString() + (methodNamespace == null ? "" : ":" + methodNamespace) + "};qname{" + Types.getLocalNameFromFullName((String)args[i].getClass().getName()) + ":" + Namespaces.makeNamespace((String)args[i].getClass().getName()) + "};in");
                    }
                    continue;
                }
                if (call.getTypeMapping().getTypeQName(args[i].getClass()) != null) {
                    qname = call.getTypeMapping().getTypeQName(args[i].getClass());
                    params.add("value" + i + ";qname{" + qname.getPrefix() + ":" + qname.getLocalPart() + ":" + qname.getNamespaceURI() + "};in");
                    continue;
                }
                params.add("value" + i + ";qname{" + Types.getLocalNameFromFullName((String)args[i].getClass().getName()) + ":" + Namespaces.makeNamespace((String)args[i].getClass().getName()) + "};in");
            }
            HashMap<Object, ArrayList<String>> map = new HashMap<Object, ArrayList<String>>();
            map.put(method, params);
            event.getMessage().setProperty("soapMethods", map);
        }
        this.setCallParams(call, event, call.getOperationName());
        String soapAction = (String)event.getMessage().getProperty("soapAction");
        if (soapAction != null) {
            soapAction = this.parseSoapAction(soapAction, call.getOperationName(), event);
            call.setSOAPActionURI(soapAction);
            call.setUseSOAPAction(Boolean.TRUE.booleanValue());
        } else {
            call.setSOAPActionURI(endpointUri.getAddress());
        }
        Iterator iterator = event.getMessage().getAttachmentNames().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            DataHandler dh = event.getMessage().getAttachment(name);
            AttachmentPart part = new AttachmentPart(dh);
            call.addAttachmentPart((Object)part);
        }
        return call;
    }

    private Object[] getArgs(UMOEvent event) throws TransformerException {
        Object payload = event.getTransformedMessage();
        Object[] args = payload instanceof Object[] ? (Object[])payload : new Object[]{payload};
        if (event.getMessage().getAttachmentNames() != null && event.getMessage().getAttachmentNames().size() > 0) {
            ArrayList<DataHandler> attachments = new ArrayList<DataHandler>();
            Iterator i = event.getMessage().getAttachmentNames().iterator();
            while (i.hasNext()) {
                attachments.add(event.getMessage().getAttachment((String)i.next()));
            }
            ArrayList<Object> temp = new ArrayList<Object>(Arrays.asList(args));
            temp.add(attachments.toArray(new DataHandler[0]));
            args = temp.toArray();
        }
        return args;
    }

    protected void setMessageContextProperties(UMOMessage message, MessageContext ctx) {
        String temp = ctx.getStrProp("MULE_CORRELATION_ID");
        if (StringUtils.isNotBlank((String)temp)) {
            message.setCorrelationId(temp);
        }
        if (StringUtils.isNotBlank((String)(temp = ctx.getStrProp("MULE_CORRELATION_GROUP_SIZE")))) {
            message.setCorrelationGroupSize(Integer.parseInt(temp));
        }
        if (StringUtils.isNotBlank((String)(temp = ctx.getStrProp("MULE_CORRELATION_SEQUENCE")))) {
            message.setCorrelationSequence(Integer.parseInt(temp));
        }
        if (StringUtils.isNotBlank((String)(temp = ctx.getStrProp("MULE_REPLYTO")))) {
            message.setReplyTo((Object)temp);
        }
    }

    protected void setMessageContextAttachments(UMOMessage message, MessageContext ctx) throws Exception {
        int x = 0;
        Iterator iterator = ctx.getMessage().getAttachments();
        while (iterator.hasNext()) {
            message.addAttachment(String.valueOf(x), ((AttachmentPart)iterator.next()).getActivationDataHandler());
            ++x;
        }
    }

    protected UMOMessage doReceive(UMOImmutableEndpoint endpoint, long timeout) throws Exception {
        Call call = new Call(this.service);
        String uri = endpoint.getEndpointURI().toString();
        call.setSOAPActionURI(uri);
        call.setTargetEndpointAddress(uri);
        Properties params = endpoint.getEndpointURI().getUserParams();
        String method = (String)params.remove("method");
        call.setOperationName(method);
        Object[] args = new String[params.size()];
        int i = 0;
        Iterator<Object> iterator = params.values().iterator();
        while (iterator.hasNext()) {
            args[i] = iterator.next().toString();
            ++i;
        }
        call.setOperationName(method);
        call.setProperty("MULE_ENDPOINT", (Object)endpoint);
        Object result = call.invoke(method, args);
        return this.createMessage(result, call);
    }

    public UMOMessage receive(String endpoint, Object[] args) throws Exception {
        Call call = new Call(this.service);
        call.setSOAPActionURI(endpoint);
        call.setTargetEndpointAddress(endpoint);
        if (!endpoint.startsWith("axis:")) {
            endpoint = "axis:" + endpoint;
        }
        MuleEndpointURI ep = new MuleEndpointURI(endpoint);
        String method = (String)ep.getParams().remove("method");
        call.setOperationName(method);
        call.setOperationName(method);
        Object result = call.invoke(method, args);
        return this.createMessage(result, call);
    }

    public UMOMessage receive(String endpoint, javax.xml.soap.SOAPEnvelope envelope) throws Exception {
        Call call = new Call(this.service);
        call.setSOAPActionURI(endpoint);
        call.setTargetEndpointAddress(endpoint);
        SOAPEnvelope result = call.invoke(new org.apache.axis.Message((Object)envelope));
        return this.createMessage(result, call);
    }

    protected UMOMessage createMessage(Object result, Call call) {
        if (result == null) {
            result = new NullPayload();
        }
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        Iterator iter = call.getMessageContext().getPropertyNames();
        while (iter.hasNext()) {
            Object key = iter.next();
            props.put(key, call.getMessageContext().getProperty(key.toString()));
        }
        props.put("soap.message", call.getMessageContext().getMessage());
        call.clearHeaders();
        call.clearOperation();
        return new MuleMessage(result, props);
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    public String parseSoapAction(String soapAction, QName method, UMOEvent event) {
        UMOEndpointURI endpointURI = event.getEndpoint().getEndpointURI();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        UMOMessage msg = event.getMessage();
        Iterator iterator = msg.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            String propertyKey = (String)iterator.next();
            properties.put(propertyKey, msg.getProperty(propertyKey));
        }
        properties.put("method", method.getLocalPart());
        properties.put("methodNamespace", method.getNamespaceURI());
        properties.put("address", endpointURI.getAddress());
        properties.put("scheme", endpointURI.getScheme());
        properties.put("host", endpointURI.getHost());
        properties.put("port", String.valueOf(endpointURI.getPort()));
        properties.put("path", endpointURI.getPath());
        properties.put("hostInfo", endpointURI.getScheme() + "://" + endpointURI.getHost() + (endpointURI.getPort() > -1 ? ":" + String.valueOf(endpointURI.getPort()) : ""));
        if (event.getComponent() != null) {
            properties.put("serviceName", event.getComponent().getDescriptor().getName());
        }
        TemplateParser tp = TemplateParser.createAntStyleParser();
        soapAction = tp.parse(properties, soapAction);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("SoapAction for this call is: " + soapAction));
        }
        return soapAction;
    }

    private void setCallParams(Call call, UMOEvent event, QName method) throws ClassNotFoundException {
        SoapMethod soapMethod;
        if (this.callParameters == null) {
            this.loadCallParams(event, method.getNamespaceURI());
        }
        if ((soapMethod = (SoapMethod)event.getMessage().removeProperty("MULE_SOAP_METHOD")) == null) {
            soapMethod = (SoapMethod)this.callParameters.get(method.getLocalPart());
        }
        if (soapMethod != null) {
            Iterator iterator = soapMethod.getNamedParameters().iterator();
            while (iterator.hasNext()) {
                NamedParameter parameter = (NamedParameter)iterator.next();
                call.addParameter(parameter.getName(), parameter.getType(), parameter.getMode());
            }
            if (soapMethod.getReturnType() != null) {
                call.setReturnType(soapMethod.getReturnType());
            } else if (soapMethod.getReturnClass() != null) {
                call.setReturnClass(soapMethod.getReturnClass());
            }
            call.setOperationName(soapMethod.getName());
        }
    }

    private void loadCallParams(UMOEvent event, String namespace) throws ClassNotFoundException {
        Map methodCalls = (Map)event.getMessage().getProperty("soapMethods");
        if (methodCalls == null) {
            return;
        }
        this.callParameters = new HashMap();
        Iterator iterator = methodCalls.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SoapMethod soapMethod = StringUtils.isEmpty((String)namespace) ? (entry.getValue() instanceof List ? new SoapMethod(entry.getKey().toString(), (List)entry.getValue()) : new SoapMethod(entry.getKey().toString(), entry.getValue().toString())) : (entry.getValue() instanceof List ? new SoapMethod(new QName(namespace, entry.getKey().toString()), (List)entry.getValue()) : new SoapMethod(new QName(namespace, entry.getKey().toString()), entry.getValue().toString()));
            this.callParameters.put(soapMethod.getName().getLocalPart(), soapMethod);
        }
    }
}

