/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis.extensions;

import java.util.HashMap;
import java.util.Map;
import org.apache.axis.client.Transport;
import org.mule.MuleException;
import org.mule.config.i18n.Message;
import org.mule.providers.soap.axis.AxisConnector;

public class MuleTransport
extends Transport {
    private static Map transports = null;

    public MuleTransport() {
        this.transportName = "MuleTransport";
    }

    public MuleTransport(String protocol) {
        this.transportName = protocol;
    }

    private static void initTransports() {
        transports = new HashMap();
        transports.put("http", HTTP.class);
        transports.put("https", HTTPS.class);
        transports.put("servlet", SERVLET.class);
        transports.put("tcp", TCP.class);
        transports.put("ssl", SSL.class);
        transports.put("jms", JMS.class);
        transports.put("vm", VM.class);
        transports.put("xmpp", XMPP.class);
        transports.put("smtp", SMTP.class);
        transports.put("smtps", SMTPS.class);
        transports.put("pop3", POP3.class);
        transports.put("pop3s", POP3S.class);
        transports.put("imap", IMAP.class);
        transports.put("imaps", IMAPS.class);
    }

    public static Class getTransportClass(String protocol) throws MuleException {
        if (protocol == null) {
            throw new NullPointerException(new Message(45, (Object)"protocol").toString());
        }
        if (!MuleTransport.isTransportSupported(protocol)) {
            throw new MuleException(new Message(115, (Object)protocol, (Object)AxisConnector.class.getName()));
        }
        return (Class)transports.get(protocol);
    }

    public static boolean isTransportSupported(String protocol) {
        if (transports == null) {
            MuleTransport.initTransports();
        }
        return transports.get(protocol) != null;
    }

    public static class SERVLET
    extends MuleTransport {
        public SERVLET() {
            super("servlet");
        }
    }

    public static class VM
    extends MuleTransport {
        public VM() {
            super("vm");
        }
    }

    public static class XMPP
    extends MuleTransport {
        public XMPP() {
            super("xmpp");
        }
    }

    public static class IMAPS
    extends MuleTransport {
        public IMAPS() {
            super("imaps");
        }
    }

    public static class IMAP
    extends MuleTransport {
        public IMAP() {
            super("imap");
        }
    }

    public static class SMTPS
    extends MuleTransport {
        public SMTPS() {
            super("smtps");
        }
    }

    public static class POP3S
    extends MuleTransport {
        public POP3S() {
            super("pop3s");
        }
    }

    public static class SMTP
    extends MuleTransport {
        public SMTP() {
            super("smtp");
        }
    }

    public static class POP3
    extends MuleTransport {
        public POP3() {
            super("pop3");
        }
    }

    public static class JMS
    extends MuleTransport {
        public JMS() {
            super("jms");
        }
    }

    public static class SSL
    extends MuleTransport {
        public SSL() {
            super("ssl");
        }
    }

    public static class TCP
    extends MuleTransport {
        public TCP() {
            super("tcp");
        }
    }

    public static class HTTPS
    extends MuleTransport {
        public HTTPS() {
            super("https");
        }
    }

    public static class HTTP
    extends MuleTransport {
        public HTTP() {
            super("http");
        }
    }
}

