/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis.extensions;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.handlers.BasicHandler;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.RequestContext;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.AbstractConnector;
import org.mule.providers.soap.axis.AxisConnector;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.routing.UMOOutboundMessageRouter;
import org.mule.umo.routing.UMOOutboundRouter;
import org.mule.util.StringUtils;

public class UniversalSender
extends BasicHandler {
    private static final long serialVersionUID = 7943380365092172940L;
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected Map endpointsCache = new ConcurrentHashMap();

    public void invoke(MessageContext msgContext) throws AxisFault {
        boolean sync = true;
        Call call = (Call)msgContext.getProperty("call_object");
        if (call == null) {
            throw new IllegalStateException("The call_object property must be set on the message context to the client Call object");
        }
        if (Boolean.TRUE.equals(call.getProperty("axis.one.way"))) {
            sync = false;
        }
        String uri = msgContext.getStrProp("transport.url");
        UMOImmutableEndpoint requestEndpoint = (UMOImmutableEndpoint)call.getProperty("MULE_ENDPOINT");
        UMOEndpoint endpoint = null;
        try {
            endpoint = this.lookupEndpoint(uri);
        }
        catch (UMOException e) {
            requestEndpoint.getConnector().handleException((Exception)((Object)e));
            return;
        }
        try {
            if (requestEndpoint.getConnector() instanceof AxisConnector) {
                msgContext.setTypeMappingRegistry(((AxisConnector)requestEndpoint.getConnector()).getAxisServer().getTypeMappingRegistry());
            }
            Object payload = null;
            int contentLength = 0;
            if (msgContext.getRequestMessage().countAttachments() > 0) {
                File temp = File.createTempFile("soap", ".tmp");
                temp.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(temp);
                msgContext.getRequestMessage().writeTo((OutputStream)fos);
                fos.close();
                contentLength = (int)temp.length();
                payload = new FileInputStream(temp);
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
                msgContext.getRequestMessage().writeTo((OutputStream)baos);
                baos.close();
                payload = baos.toByteArray();
            }
            HashMap<String, Object> props = new HashMap<String, Object>();
            Iterator iterator = msgContext.getPropertyNames();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                if (name.equals("call_object") || name.equals("wsdl.service")) continue;
                props.put(name, msgContext.getProperty(name));
            }
            UMOMessage currentMessage = RequestContext.getEvent().getMessage();
            String METHOD = "method";
            String SOAP_METHODS = "soapMethods";
            Iterator iterator2 = currentMessage.getPropertyNames().iterator();
            while (iterator2.hasNext()) {
                String name = (String)iterator2.next();
                if (StringUtils.equals((String)name, (String)"soapMethods") || StringUtils.equals((String)name, (String)"soapAction") || StringUtils.equals((String)name, (String)"method") || StringUtils.equals((String)name, (String)"method") || name.startsWith("MULE_") && !StringUtils.equals((String)name, (String)"MULE_USER")) continue;
                props.put(name, currentMessage.getProperty(name));
            }
            if (call.useSOAPAction()) {
                uri = call.getSOAPActionURI();
            }
            props.put("SOAPAction", uri);
            if (contentLength > 0) {
                props.put("Content-Length", Integer.toString(contentLength));
            }
            if (props.get("Content-Type") == null) {
                props.put("Content-Type", "text/xml");
            }
            MuleMessage message = new MuleMessage(payload, props);
            MuleSession session = new MuleSession((UMOMessage)message, ((AbstractConnector)endpoint.getConnector()).getSessionHandler());
            MuleEvent dispatchEvent = new MuleEvent((UMOMessage)message, (UMOImmutableEndpoint)endpoint, (UMOSession)session, sync);
            this.logger.info((Object)("Making Axis soap request on: " + uri));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Soap request is:\n" + payload.toString()));
            }
            if (sync) {
                MuleEndpoint syncEndpoint = new MuleEndpoint(dispatchEvent.getEndpoint());
                syncEndpoint.setRemoteSync(true);
                dispatchEvent = new MuleEvent(dispatchEvent.getMessage(), (UMOImmutableEndpoint)syncEndpoint, dispatchEvent.getSession(), dispatchEvent.isSynchronous());
                UMOMessage result = session.sendEvent((UMOEvent)dispatchEvent);
                if (result != null) {
                    byte[] response = result.getPayloadAsBytes();
                    Message responseMessage = new Message((Object)response);
                    msgContext.setResponseMessage(responseMessage);
                } else {
                    this.logger.warn((Object)("No response message was returned from synchronous call to: " + uri));
                }
                if (payload instanceof File) {
                    ((File)payload).delete();
                }
            } else {
                session.dispatchEvent((UMOEvent)dispatchEvent);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to dispatch soap event from Axis Universal transport: " + e.toString()));
            requestEndpoint.getConnector().handleException(e);
        }
    }

    protected UMOEndpoint lookupEndpoint(String uri) throws UMOException {
        MuleEndpoint ep;
        UMODescriptor axis = MuleManager.getInstance().getModel().getDescriptor("_axisServiceComponent");
        MuleEndpointURI endpoint = new MuleEndpointURI(uri);
        if (axis != null) {
            ep = (UMOEndpoint)this.endpointsCache.get(endpoint.getAddress());
            if (ep == null) {
                this.updateEndpointCache(axis.getOutboundRouter());
                ep = (UMOEndpoint)this.endpointsCache.get(endpoint.getAddress());
                if (ep == null) {
                    this.logger.debug((Object)("Dispatch Endpoint uri: " + uri + " not found on the cache. Creating the endpoint instead."));
                    ep = new MuleEndpoint(uri, false);
                } else {
                    this.logger.info((Object)("Found endpoint: " + uri + " on the Axis service component"));
                }
            } else {
                this.logger.info((Object)("Found endpoint: " + uri + " on the Axis service component"));
            }
        } else {
            ep = new MuleEndpoint(uri, false);
        }
        return ep;
    }

    private void updateEndpointCache(UMOOutboundMessageRouter router) {
        this.endpointsCache.clear();
        Iterator iterator = router.getRouters().iterator();
        while (iterator.hasNext()) {
            UMOOutboundRouter r = (UMOOutboundRouter)iterator.next();
            Iterator iterator1 = r.getEndpoints().iterator();
            while (iterator1.hasNext()) {
                UMOEndpoint endpoint = (UMOEndpoint)iterator1.next();
                this.endpointsCache.put(endpoint.getEndpointURI().getAddress(), endpoint);
            }
        }
    }
}

