/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Call;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.deployment.wsdd.WSDDProvider;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.server.AxisServer;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.fromJava.Types;
import org.mule.MuleManager;
import org.mule.config.ExceptionHelper;
import org.mule.config.ExceptionReader;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.internal.notifications.ModelNotificationListener;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.providers.http.servlet.ServletConnector;
import org.mule.providers.service.ConnectorFactory;
import org.mule.providers.soap.MethodFixInterceptor;
import org.mule.providers.soap.axis.AxisFaultExceptionReader;
import org.mule.providers.soap.axis.AxisServiceComponent;
import org.mule.providers.soap.axis.extensions.MuleConfigProvider;
import org.mule.providers.soap.axis.extensions.MuleTransport;
import org.mule.providers.soap.axis.extensions.WSDDFileProvider;
import org.mule.providers.soap.axis.extensions.WSDDJavaMuleProvider;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.UMOInterceptor;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOServerNotificationListener;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.ClassUtils;

public class AxisConnector
extends AbstractServiceEnabledConnector
implements ModelNotificationListener {
    public static final QName QNAME_MULE_PROVIDER;
    public static final QName QNAME_MULE_TYPE_MAPPINGS;
    public static final String DEFAULT_MULE_NAMESPACE_URI = "http://www.muleumo.org";
    public static final String DEFAULT_MULE_AXIS_SERVER_CONFIG = "mule-axis-server-config.wsdd";
    public static final String DEFAULT_MULE_AXIS_CLIENT_CONFIG = "mule-axis-client-config.wsdd";
    public static final String AXIS_SERVICE_COMPONENT_NAME = "_axisServiceComponent";
    public static final String AXIS_SERVICE_PROPERTY = "_axisService";
    public static final String AXIS_CLIENT_CONFIG_PROPERTY = "clientConfig";
    public static final String SERVICE_PROPERTY_COMPONENT_NAME = "componentName";
    public static final String SERVICE_PROPERTY_SERVCE_PATH = "servicePath";
    public static final String WSDL_URL_PROPERTY = "wsdlUrl";
    private String serverConfig;
    private AxisServer axisServer;
    private SimpleProvider serverProvider;
    private String clientConfig;
    private SimpleProvider clientProvider;
    private List beanTypes;
    private MuleDescriptor axisDescriptor;
    private Map axisTransportProtocols;
    private List servletServices = new ArrayList();
    private List supportedSchemes;
    private boolean doAutoTypes = true;
    private boolean treatMapAsNamedParams = true;

    public AxisConnector() {
        this.registerProtocols();
    }

    protected void registerProtocols() {
        this.supportedSchemes = new ArrayList();
        this.supportedSchemes.add("http");
        this.supportedSchemes.add("https");
        this.supportedSchemes.add("servlet");
        this.supportedSchemes.add("vm");
        this.supportedSchemes.add("jms");
        this.supportedSchemes.add("xmpp");
        this.supportedSchemes.add("smtp");
        this.supportedSchemes.add("smtps");
        this.supportedSchemes.add("pop3");
        this.supportedSchemes.add("pop3s");
        this.supportedSchemes.add("imap");
        this.supportedSchemes.add("imaps");
        this.supportedSchemes.add("ssl");
        this.supportedSchemes.add("tcp");
        Iterator iterator = this.supportedSchemes.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            this.registerSupportedProtocol(s);
        }
    }

    public void doInitialise() throws InitialisationException {
        super.doInitialise();
        this.axisTransportProtocols = new HashMap();
        try {
            Iterator iterator = this.supportedSchemes.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                this.axisTransportProtocols.put(s, MuleTransport.getTransportClass(s));
                this.registerSupportedProtocol(s);
            }
            MuleManager.getInstance().registerListener((UMOServerNotificationListener)this);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
        if (this.serverConfig == null) {
            this.serverConfig = DEFAULT_MULE_AXIS_SERVER_CONFIG;
        }
        if (this.clientConfig == null) {
            this.clientConfig = DEFAULT_MULE_AXIS_CLIENT_CONFIG;
        }
        this.serverProvider = this.createAxisProvider(this.serverConfig);
        this.clientProvider = this.createAxisProvider(this.clientConfig);
        this.axisServer = new AxisServer((EngineConfiguration)this.serverProvider);
        this.axisServer.setOption("axis.doAutoTypes", (Object)this.doAutoTypes);
        WSDDProvider.registerProvider((QName)QNAME_MULE_PROVIDER, (WSDDProvider)new WSDDJavaMuleProvider(this));
        try {
            this.registerTransportTypes();
        }
        catch (ClassNotFoundException e) {
            throw new InitialisationException(new Message(122, (Object)e.getMessage()), (Throwable)e, (Object)this);
        }
        String handlerPkgs = System.getProperty("java.protocol.handler.pkgs", null);
        if (handlerPkgs != null) {
            if (!handlerPkgs.endsWith("|")) {
                handlerPkgs = handlerPkgs + "|";
            }
            handlerPkgs = "org.mule.providers.soap.axis.transport|" + handlerPkgs;
            System.setProperty("java.protocol.handler.pkgs", handlerPkgs);
            this.logger.debug((Object)("Setting java.protocol.handler.pkgs to: " + handlerPkgs));
        }
        try {
            this.registerTypes((TypeMappingRegistryImpl)this.axisServer.getTypeMappingRegistry(), this.beanTypes);
        }
        catch (ClassNotFoundException e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
    }

    protected void registerTransportTypes() throws ClassNotFoundException {
        Iterator iterator = this.getAxisTransportProtocols().keySet().iterator();
        while (iterator.hasNext()) {
            String protocol = (String)iterator.next();
            Object temp = this.getAxisTransportProtocols().get(protocol);
            Class clazz = null;
            clazz = temp instanceof String ? ClassUtils.loadClass((String)temp.toString(), ((Object)((Object)this)).getClass()) : (Class)temp;
            Call.setTransportForProtocol((String)protocol, (Class)clazz);
        }
    }

    protected SimpleProvider createAxisProvider(String config) throws InitialisationException {
        WSDDFileProvider fileProvider = new WSDDFileProvider(config);
        fileProvider.setSearchClasspath(true);
        return new MuleConfigProvider((EngineConfiguration)fileProvider);
    }

    public String getProtocol() {
        return "axis";
    }

    protected Object getReceiverKey(UMOComponent component, UMOEndpoint endpoint) {
        if (endpoint.getEndpointURI().getPort() == -1) {
            return component.getDescriptor().getName();
        }
        return endpoint.getEndpointURI().getAddress() + "/" + component.getDescriptor().getName();
    }

    public UMOMessageReceiver createReceiver(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        if (!endpoint.isSynchronousSet() && !endpoint.isSynchronous()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"overriding endpoint synchronicity and setting it to true. Web service requests are executed in a single thread");
            }
            endpoint.setSynchronous(true);
        }
        return super.createReceiver(component, endpoint);
    }

    protected void unregisterReceiverWithMuleService(UMOMessageReceiver receiver, UMOEndpointURI ep) throws UMOException {
        block3: {
            String endpointKey = this.getCounterEndpointKey(receiver.getEndpointURI());
            Iterator iterator = this.axisDescriptor.getInboundRouter().getEndpoints().iterator();
            if (!iterator.hasNext()) break block3;
            UMOEndpoint umoEndpoint = (UMOEndpoint)iterator.next();
            if (endpointKey.startsWith(umoEndpoint.getEndpointURI().getAddress())) {
                this.logger.info((Object)("Unregistering Axis endpoint: " + endpointKey + " for service: " + receiver.getComponent().getDescriptor().getName()));
            }
            try {
                umoEndpoint.getConnector().unregisterListener(receiver.getComponent(), receiver.getEndpoint());
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to unregister Axis endpoint: " + endpointKey + " for service: " + receiver.getComponent().getDescriptor().getName() + ". Error is: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void registerReceiverWithMuleService(UMOMessageReceiver receiver, UMOEndpointURI ep) throws UMOException {
        if (this.axisDescriptor == null) {
            this.axisDescriptor = (MuleDescriptor)MuleManager.getInstance().getModel().getDescriptor(AXIS_SERVICE_COMPONENT_NAME);
            if (this.axisDescriptor == null) {
                this.axisDescriptor = this.createAxisDescriptor();
            } else {
                MuleManager.getInstance().getModel().unregisterComponent((UMODescriptor)this.axisDescriptor);
            }
            if (this.axisDescriptor.getProperties().get("axisServer") == null) {
                this.axisDescriptor.getProperties().put("axisServer", this.axisServer);
            }
            this.axisDescriptor.setContainerManaged(false);
        }
        String serviceName = receiver.getComponent().getDescriptor().getName();
        String endpoint = null;
        String scheme = ep.getScheme().toLowerCase();
        endpoint = scheme.equals("jms") || scheme.equals("vm") ? ep.toString() : receiver.getEndpointURI().getAddress() + "/" + serviceName;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Modified endpoint with " + scheme + " scheme to " + endpoint));
        }
        boolean sync = false;
        if (!receiver.getEndpoint().isSynchronousSet()) {
            if (scheme.equals("http") || scheme.equals("https") || scheme.equals("ssl") || scheme.equals("tcp")) {
                sync = true;
            }
        } else {
            sync = receiver.getEndpoint().isSynchronous();
        }
        MuleEndpoint serviceEndpoint = new MuleEndpoint(endpoint, true);
        serviceEndpoint.setSynchronous(sync);
        serviceEndpoint.setName(ep.getScheme() + ":" + serviceName);
        serviceEndpoint.setFilter(receiver.getEndpoint().getFilter());
        receiver.getEndpoint().setFilter(null);
        serviceEndpoint.setSecurityFilter(receiver.getEndpoint().getSecurityFilter());
        receiver.getEndpoint().setSecurityFilter(null);
        if (receiver.getEndpoint().getTransformer() != null) {
            serviceEndpoint.setTransformer(receiver.getEndpoint().getTransformer());
            receiver.getEndpoint().setTransformer(null);
        }
        serviceEndpoint.getProperties().putAll(receiver.getEndpoint().getProperties());
        this.axisDescriptor.getInboundRouter().addEndpoint((UMOEndpoint)serviceEndpoint);
    }

    private String getCounterEndpointKey(UMOEndpointURI endpointURI) {
        StringBuffer endpointKey = new StringBuffer(64);
        endpointKey.append(endpointURI.getScheme());
        endpointKey.append("://");
        endpointKey.append(endpointURI.getHost());
        if (endpointURI.getPort() > -1) {
            endpointKey.append(":");
            endpointKey.append(endpointURI.getPort());
        }
        return endpointKey.toString();
    }

    protected MuleDescriptor createAxisDescriptor() {
        MuleDescriptor axisDescriptor = (MuleDescriptor)MuleManager.getInstance().getModel().getDescriptor(AXIS_SERVICE_COMPONENT_NAME);
        if (axisDescriptor == null) {
            axisDescriptor = new MuleDescriptor(AXIS_SERVICE_COMPONENT_NAME);
            axisDescriptor.setImplementation((Object)AxisServiceComponent.class.getName());
        }
        return axisDescriptor;
    }

    protected void doStart() throws UMOException {
        this.axisServer.start();
    }

    protected void doStop() throws UMOException {
        this.axisServer.stop();
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
    }

    public List getBeanTypes() {
        return this.beanTypes;
    }

    public void setBeanTypes(List beanTypes) {
        this.beanTypes = beanTypes;
    }

    public String getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(String clientConfig) {
        this.clientConfig = clientConfig;
    }

    public AxisServer getAxisServer() {
        return this.axisServer;
    }

    public void setAxisServer(AxisServer axisServer) {
        this.axisServer = axisServer;
    }

    public SimpleProvider getServerProvider() {
        return this.serverProvider;
    }

    public void setServerProvider(SimpleProvider serverProvider) {
        this.serverProvider = serverProvider;
    }

    public SimpleProvider getClientProvider() {
        return this.clientProvider;
    }

    public void setClientProvider(SimpleProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    public Map getAxisTransportProtocols() {
        return this.axisTransportProtocols;
    }

    public void setAxisTransportProtocols(Map axisTransportProtocols) {
        this.axisTransportProtocols.putAll(axisTransportProtocols);
    }

    void addServletService(SOAPService service) {
        this.servletServices.add(service);
    }

    public List getSupportedSchemes() {
        return this.supportedSchemes;
    }

    public void setSupportedSchemes(List supportedSchemes) {
        this.supportedSchemes = supportedSchemes;
    }

    public boolean isDoAutoTypes() {
        return this.doAutoTypes;
    }

    public void setDoAutoTypes(boolean doAutoTypes) {
        this.doAutoTypes = doAutoTypes;
    }

    void registerTypes(TypeMappingRegistryImpl registry, List types) throws ClassNotFoundException {
        if (types != null) {
            Iterator iterator = types.iterator();
            while (iterator.hasNext()) {
                Class clazz = ClassUtils.loadClass((String)iterator.next().toString(), ((Object)((Object)this)).getClass());
                String localName = Types.getLocalNameFromFullName((String)clazz.getName());
                QName xmlType = new QName(Namespaces.makeNamespace((String)clazz.getName()), localName);
                registry.getDefaultTypeMapping().register(clazz, xmlType, (SerializerFactory)new BeanSerializerFactory(clazz, xmlType), (DeserializerFactory)new BeanDeserializerFactory(clazz, xmlType));
            }
        }
    }

    public boolean isTreatMapAsNamedParams() {
        return this.treatMapAsNamedParams;
    }

    public void setTreatMapAsNamedParams(boolean treatMapAsNamedParams) {
        this.treatMapAsNamedParams = treatMapAsNamedParams;
    }

    public void onNotification(UMOServerNotification notification) {
        if (notification.getAction() == 206 && !MuleManager.getInstance().getModel().isComponentRegistered(AXIS_SERVICE_COMPONENT_NAME)) {
            try {
                if (this.axisDescriptor == null) {
                    this.axisDescriptor = this.createAxisDescriptor();
                }
                this.axisDescriptor.addInterceptor((UMOInterceptor)new MethodFixInterceptor());
                MuleManager.getInstance().getModel().registerComponent((UMODescriptor)this.axisDescriptor);
                Iterator iterator = this.servletServices.iterator();
                while (iterator.hasNext()) {
                    SOAPService service = (SOAPService)iterator.next();
                    ServletConnector servletConnector = (ServletConnector)ConnectorFactory.getConnectorByProtocol((String)"servlet");
                    String url = servletConnector.getServletUrl();
                    if (url != null) {
                        service.getServiceDescription().setEndpointURL(url + "/" + service.getName());
                        continue;
                    }
                    this.logger.error((Object)("The servletUrl property on the ServletConntector has not been set this means that wsdl generation for service '" + service.getName() + "' may be incorrect"));
                }
                this.servletServices.clear();
                this.servletServices = null;
            }
            catch (UMOException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    static {
        ExceptionHelper.registerExceptionReader((ExceptionReader)new AxisFaultExceptionReader());
        QNAME_MULE_PROVIDER = new QName("http://xml.apache.org/axis/wsdd/providers/java", "Mule");
        QNAME_MULE_TYPE_MAPPINGS = new QName("http://www.muleumo.org/ws/mappings", "Mule");
    }
}

