/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisProperties;
import org.apache.axis.Handler;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.commons.lang.StringUtils;
import org.mule.config.i18n.Message;
import org.mule.impl.InitialisationCallback;
import org.mule.impl.MuleDescriptor;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.soap.NamedParameter;
import org.mule.providers.soap.ServiceProxy;
import org.mule.providers.soap.SoapMethod;
import org.mule.providers.soap.axis.AxisConnector;
import org.mule.providers.soap.axis.AxisInitialisationCallback;
import org.mule.providers.soap.axis.extensions.MuleMsgProvider;
import org.mule.providers.soap.axis.extensions.MuleRPCProvider;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;

public class AxisMessageReceiver
extends AbstractMessageReceiver {
    protected AxisConnector connector;
    protected SOAPService service;

    public AxisMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
        this.connector = (AxisConnector)connector;
        try {
            this.init();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
    }

    protected void init() throws Exception {
        String wsdlFile;
        StringBuffer buf;
        AxisProperties.setProperty((String)"axis.doAutoTypes", (String)String.valueOf(this.connector.isDoAutoTypes()));
        MuleDescriptor descriptor = (MuleDescriptor)this.component.getDescriptor();
        String style = (String)descriptor.getProperties().get("style");
        String use = (String)descriptor.getProperties().get("use");
        String doc = (String)descriptor.getProperties().get("documentation");
        UMOEndpointURI uri = this.endpoint.getEndpointURI();
        String serviceName = this.component.getDescriptor().getName();
        SOAPService existing = this.connector.getAxisServer().getService(serviceName);
        if (existing != null) {
            this.service = existing;
            this.logger.debug((Object)("Using existing service for " + serviceName));
        } else {
            if (style != null && style.equalsIgnoreCase("message")) {
                this.logger.debug((Object)"Creating Message Provider");
                this.service = new SOAPService((Handler)new MuleMsgProvider(this.connector));
            } else {
                this.logger.debug((Object)"Creating RPC Provider");
                this.service = new SOAPService((Handler)new MuleRPCProvider(this.connector));
            }
            this.service.setEngine((AxisEngine)this.connector.getAxisServer());
        }
        String servicePath = uri.getPath();
        this.service.setOption(serviceName, (Object)this);
        this.service.setOption("servicePath", (Object)servicePath);
        this.service.setOption("componentName", (Object)serviceName);
        this.service.setName(serviceName);
        HashMap<String, String> options = (HashMap<String, String>)descriptor.getProperties().get("axisOptions");
        if (options == null) {
            options = new HashMap<String, String>(2);
        }
        if (options.get("wsdlServiceElement") == null) {
            options.put("wsdlServiceElement", serviceName);
        }
        Iterator iterator = options.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.service.setOption(entry.getKey().toString(), entry.getValue());
            this.logger.debug((Object)("Adding Axis option: " + entry));
        }
        Class[] interfaces = ServiceProxy.getInterfacesForComponent((UMOComponent)this.component);
        if (interfaces.length == 0) {
            throw new InitialisationException(new Message(160, (Object)serviceName), (Object)this.component);
        }
        String methodNames = "*";
        Map methods = (Map)this.endpoint.getProperties().get("soapMethods");
        if (methods == null) {
            methods = (Map)descriptor.getProperties().get("soapMethods");
        }
        if (methods != null) {
            Iterator i = methods.keySet().iterator();
            buf = new StringBuffer(64);
            while (i.hasNext()) {
                String name = (String)i.next();
                Object m = methods.get(name);
                SoapMethod method = null;
                method = m instanceof List ? new SoapMethod(name, (List)m) : new SoapMethod(name, (String)m);
                List namedParameters = method.getNamedParameters();
                ParameterDesc[] parameters = new ParameterDesc[namedParameters.size()];
                for (int j = 0; j < namedParameters.size(); ++j) {
                    NamedParameter parameter = (NamedParameter)namedParameters.get(j);
                    byte mode = 3;
                    if (parameter.getMode().equals(ParameterMode.IN)) {
                        mode = 1;
                    } else if (parameter.getMode().equals(ParameterMode.OUT)) {
                        mode = 2;
                    }
                    parameters[j] = new ParameterDesc(parameter.getName(), mode, parameter.getType());
                }
                this.service.getServiceDescription().addOperationDesc(new OperationDesc(method.getName().getLocalPart(), parameters, method.getReturnType()));
                buf.append(method.getName().getLocalPart() + ",");
            }
            methodNames = buf.toString();
            methodNames = methodNames.substring(0, methodNames.length() - 1);
        } else {
            String[] methodNamesArray = ServiceProxy.getMethodNames((Class[])interfaces);
            buf = new StringBuffer(64);
            for (int i = 0; i < methodNamesArray.length; ++i) {
                buf.append(methodNamesArray[i]).append(",");
            }
            methodNames = buf.toString();
            methodNames = methodNames.substring(0, methodNames.length() - 1);
        }
        String className = interfaces[0].getName();
        String namespace = (String)descriptor.getProperties().get("serviceNamespace");
        if (namespace == null) {
            namespace = Namespaces.makeNamespace((String)className);
        }
        if ((wsdlFile = (String)descriptor.getProperties().get("wsdlFile")) != null) {
            this.service.getServiceDescription().setWSDLFile(wsdlFile);
        }
        this.setOptionIfNotset(this.service, "wsdlServicePort", serviceName);
        this.setOptionIfNotset(this.service, "className", className);
        this.setOptionIfNotset(this.service, "scope", "Request");
        if (StringUtils.isNotBlank((String)namespace)) {
            this.setOptionIfNotset(this.service, "wsdlTargetNamespace", namespace);
        }
        if (methodNames == null) {
            this.setOptionIfNotset(this.service, "allowedMethods", "*");
        } else {
            this.setOptionIfNotset(this.service, "allowedMethods", methodNames);
        }
        if (style != null) {
            Style s = Style.getStyle((String)style);
            if (s == null) {
                throw new InitialisationException(new Message(154, (Object)style, (Object)"style"), (Object)this);
            }
            this.service.setStyle(s);
        }
        if (use != null) {
            Use u = Use.getUse((String)use);
            if (u == null) {
                throw new InitialisationException(new Message(154, (Object)use, (Object)"use"), (Object)this);
            }
            this.service.setUse(u);
        }
        this.service.getServiceDescription().setDocumentation(doc);
        this.service.setName(serviceName);
        descriptor.addInitialisationCallback((InitialisationCallback)new AxisInitialisationCallback(this.service));
        if (uri.getScheme().equalsIgnoreCase("servlet")) {
            this.connector.addServletService(this.service);
            String endpointUrl = uri.getAddress() + "/" + serviceName;
            endpointUrl = endpointUrl.replaceFirst("servlet:", "http:");
            this.service.getServiceDescription().setEndpointURL(endpointUrl);
        } else {
            this.service.getServiceDescription().setEndpointURL(uri.getAddress() + "/" + serviceName);
        }
        if (StringUtils.isNotBlank((String)namespace)) {
            this.service.getServiceDescription().setDefaultNamespace(namespace);
        }
        this.service.init();
        this.service.stop();
    }

    protected void doConnect() throws Exception {
        this.connector.getServerProvider().deployService(this.service.getName(), this.service);
        this.connector.registerReceiverWithMuleService((UMOMessageReceiver)this, this.endpoint.getEndpointURI());
    }

    protected void doDisconnect() throws Exception {
        try {
            this.doStop();
        }
        catch (UMOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.connector.unregisterReceiverWithMuleService((UMOMessageReceiver)this, this.endpoint.getEndpointURI());
    }

    protected void doStart() throws UMOException {
        if (this.service != null) {
            this.service.start();
        }
    }

    protected void doStop() throws UMOException {
        if (this.service != null) {
            this.service.stop();
        }
    }

    protected void doDispose() {
    }

    protected void setOptionIfNotset(SOAPService service, String option, Object value) {
        Object val = service.getOption(option);
        if (val == null) {
            service.setOption(option, value);
        }
    }

    public SOAPService getService() {
        return this.service;
    }
}

