/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis.extensions;

import java.lang.reflect.Proxy;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.providers.java.MsgProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.RequestContext;
import org.mule.impl.model.ModelHelper;
import org.mule.providers.soap.ServiceProxy;
import org.mule.providers.soap.axis.AxisConnector;
import org.mule.providers.soap.axis.AxisMessageReceiver;
import org.mule.providers.soap.axis.AxisServiceProxy;
import org.mule.umo.UMOComponent;

public class MuleMsgProvider
extends MsgProvider {
    private static final long serialVersionUID = -4399291846942449361L;
    private AxisConnector connector;
    private static Log logger = LogFactory.getLog((Class)MuleMsgProvider.class);
    private String METHOD_BODYARRAY = "soapbodyelement";
    private String METHOD_ELEMENTARRAY = "element";
    private String METHOD_DOCUMENT = "document";

    public MuleMsgProvider(AxisConnector connector) {
        this.connector = connector;
    }

    protected Object makeNewServiceObject(MessageContext messageContext, String s) throws Exception {
        AxisMessageReceiver receiver;
        String transUrl = (String)messageContext.getProperty("transport.url");
        int i = transUrl.indexOf(63);
        if (i > -1) {
            transUrl = transUrl.substring(0, i);
        }
        if ((receiver = (AxisMessageReceiver)this.connector.lookupReceiver(transUrl)) == null) {
            receiver = (AxisMessageReceiver)this.connector.lookupReceiver(messageContext.getTargetService());
        }
        if (receiver == null) {
            throw new AxisFault("Could not find Mule registered service: " + s);
        }
        Class[] classes = ServiceProxy.getInterfacesForComponent((UMOComponent)receiver.getComponent());
        return AxisServiceProxy.createProxy(receiver, true, classes);
    }

    protected Class getServiceClass(String s, SOAPService soapService, MessageContext messageContext) throws AxisFault {
        UMOComponent component = ModelHelper.getComponent((String)soapService.getName());
        try {
            Class[] classes = ServiceProxy.getInterfacesForComponent((UMOComponent)component);
            return Proxy.getProxyClass(Thread.currentThread().getContextClassLoader(), classes);
        }
        catch (Exception e) {
            throw new AxisFault("Failed to implementation class for component: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void setOperationStyle(MessageContext msgContext) {
        int methodType = msgContext.getOperation().getMessageOperationStyle();
        if (methodType > -1) {
            return;
        }
        OperationDesc operation = msgContext.getOperation();
        String methodSignature = operation.getMethod().toString().toLowerCase();
        methodType = methodSignature.indexOf(this.METHOD_BODYARRAY) != -1 ? 1 : (methodSignature.indexOf(this.METHOD_ELEMENTARRAY) != -1 ? 3 : (methodSignature.indexOf(this.METHOD_DOCUMENT) != -1 ? 4 : 2));
        operation.setMessageOperationStyle(methodType);
        logger.debug((Object)("Now Invoking service (Method Format) " + operation.getMethod().toString()));
        logger.debug((Object)("Now Invoking service (MethodType) " + String.valueOf(operation.getMessageOperationStyle())));
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        super.invoke(msgContext);
        if (RequestContext.getExceptionPayload() != null) {
            Throwable t = RequestContext.getExceptionPayload().getException();
            if (t instanceof Exception) {
                AxisFault fault = AxisFault.makeFault((Exception)((Exception)t));
                if (t instanceof RuntimeException) {
                    fault.addFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION, "true");
                }
                throw fault;
            }
            throw (Error)t;
        }
    }
}

