/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mule.config.ExceptionHelper;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.soap.ServiceProxy;
import org.mule.providers.soap.axis.extras.AxisCleanAndAddProperties;
import org.mule.umo.UMOException;
import org.mule.umo.UMOExceptionPayload;
import org.mule.umo.UMOMessage;
import org.mule.umo.provider.UMOMessageAdapter;

public class AxisServiceProxy
extends ServiceProxy {
    public static Object createProxy(AbstractMessageReceiver receiver, boolean synchronous, Class[] classes) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return Proxy.newProxyInstance(cl, classes, AxisServiceProxy.createServiceHandler(receiver, synchronous));
    }

    public static InvocationHandler createServiceHandler(AbstractMessageReceiver receiver, boolean synchronous) {
        return new AxisServiceHandler(receiver, synchronous);
    }

    private static class AxisServiceHandler
    implements InvocationHandler {
        private AbstractMessageReceiver receiver;
        private boolean synchronous = true;

        public AxisServiceHandler(AbstractMessageReceiver receiver, boolean synchronous) {
            this.receiver = receiver;
            this.synchronous = synchronous;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            UMOMessageAdapter messageAdapter = this.receiver.getConnector().getMessageAdapter((Object)args);
            messageAdapter.setProperty("method", (Object)method);
            messageAdapter.addProperties(AxisCleanAndAddProperties.cleanAndAdd(RequestContext.getEventContext()));
            UMOMessage message = this.receiver.routeMessage((UMOMessage)new MuleMessage((Object)messageAdapter), this.synchronous);
            if (message != null) {
                UMOExceptionPayload wsException = message.getExceptionPayload();
                if (wsException != null) {
                    UMOException umoException = ExceptionHelper.getRootMuleException((Throwable)wsException.getException());
                    if (umoException.getCause() != null) {
                        throw umoException.getCause();
                    }
                    throw umoException;
                }
                return message.getPayload();
            }
            return null;
        }
    }
}

