/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis;

import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.AttachmentPart;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.providers.soap.MuleSoapHeaders;
import org.mule.providers.soap.i18n.SoapMessages;
import org.mule.transformers.simple.SerializableToByteArray;
import org.mule.umo.MessagingException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.StringUtils;

public class AxisMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = -923205879581370143L;
    private final Object payload;
    private final SOAPMessage message;
    private UMOTransformer trans;

    public AxisMessageAdapter(Object message) throws MessagingException {
        block10: {
            this.trans = new SerializableToByteArray();
            this.payload = message;
            try {
                MessageContext ctx = MessageContext.getCurrentContext();
                if (ctx != null) {
                    MuleSoapHeaders header = new MuleSoapHeaders(ctx.getMessage().getSOAPPart().getEnvelope().getHeader());
                    if (StringUtils.isNotBlank((String)header.getReplyTo())) {
                        this.setReplyTo(header.getReplyTo());
                    }
                    if (StringUtils.isNotBlank((String)header.getCorrelationGroup())) {
                        this.setCorrelationGroupSize(Integer.parseInt(header.getCorrelationGroup()));
                    }
                    if (StringUtils.isNotBlank((String)header.getCorrelationSequence())) {
                        this.setCorrelationSequence(Integer.parseInt(header.getCorrelationSequence()));
                    }
                    if (StringUtils.isNotBlank((String)header.getCorrelationId())) {
                        this.setCorrelationId(header.getCorrelationId());
                    }
                    this.message = ctx.getMessage();
                    int x = 1;
                    try {
                        Iterator i = this.message.getAttachments();
                        while (i.hasNext()) {
                            super.addAttachment(String.valueOf(x), ((AttachmentPart)i.next()).getActivationDataHandler());
                            ++x;
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        this.logger.fatal((Object)"Failed to read attachments", (Throwable)e);
                        break block10;
                    }
                }
                this.message = null;
            }
            catch (SOAPException e) {
                throw new MessagingException(SoapMessages.failedToProcessSoapHeaders(), message, (Throwable)e);
            }
        }
    }

    public String getPayloadAsString(String encoding) throws Exception {
        return new String(this.getPayloadAsBytes(), encoding);
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return (byte[])this.trans.transform(this.payload);
    }

    public Object getPayload() {
        return this.payload;
    }

    public SOAPMessage getSoapMessage() {
        return this.message;
    }

    public void addAttachment(String name, DataHandler dataHandler) throws Exception {
        this.message.addAttachmentPart((javax.xml.soap.AttachmentPart)new AttachmentPart(dataHandler));
        super.addAttachment(name, dataHandler);
    }

    public void removeAttachment(String name) throws Exception {
        if (!"all".equalsIgnoreCase(name)) {
            throw new SOAPException(SoapMessages.cannotRemoveSingleAttachment().toString());
        }
        this.message.removeAllAttachments();
        this.attachments.clear();
    }
}

