/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis.extensions;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.DefaultSocketFactory;
import org.apache.axis.components.net.SocketFactory;
import org.apache.axis.components.net.SocketFactoryFactory;
import org.apache.axis.encoding.Base64;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.transport.http.ChunkedInputStream;
import org.apache.axis.transport.http.ChunkedOutputStream;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.transport.http.HTTPSender;
import org.apache.axis.transport.http.SocketHolder;
import org.apache.axis.transport.http.SocketInputStream;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.TeeOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;

public class MuleHttpSender
extends BasicHandler {
    private static final long serialVersionUID = -1730816323289419500L;
    protected static final Log log = LogFactory.getLog((String)HTTPSender.class.getName());
    private static final String ACCEPT_HEADERS = "Accept: application/soap+xml, application/dime, multipart/related, text/*\r\nUser-Agent: " + Messages.getMessage((String)"axisUserAgent") + "\r\n";
    private static final String CACHE_HEADERS = "Cache-Control: no-cache\r\nPragma: no-cache\r\n";
    private static final String CHUNKED_HEADER = HTTPConstants.HEADER_TRANSFER_ENCODING + ": " + HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED + "\r\n";
    private static final String HEADER_CONTENT_TYPE_LC = "Content-Type".toLowerCase();
    private static final String HEADER_LOCATION_LC = "Location".toLowerCase();
    private static final String HEADER_CONTENT_LOCATION_LC = "Content-Location".toLowerCase();
    private static final String HEADER_CONTENT_LENGTH_LC = "Content-Length".toLowerCase();
    private static final String HEADER_TRANSFER_ENCODING_LC = HTTPConstants.HEADER_TRANSFER_ENCODING.toLowerCase();
    URL targetURL;

    public void invoke(MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"enter00", (String)"HTTPSender::invoke"));
        }
        try {
            String transURL;
            Call call = (Call)msgContext.getProperty("call_object");
            String uri = transURL = msgContext.getStrProp("transport.url");
            if (call != null && call.useSOAPAction()) {
                uri = call.getSOAPActionURI();
            }
            msgContext.setProperty("SOAPAction", (Object)uri);
            BooleanHolder useFullURL = new BooleanHolder(false);
            StringBuffer otherHeaders = new StringBuffer(64);
            this.targetURL = new URL(transURL);
            String host = this.targetURL.getHost();
            int port = this.targetURL.getPort();
            SocketHolder socketHolder = new SocketHolder(null);
            InputStream inp = this.writeToSocket(socketHolder, msgContext, this.targetURL, otherHeaders, host, port, msgContext.getTimeout(), useFullURL);
            if (msgContext.isClient() && call != null && Boolean.TRUE.equals(call.getProperty("axis.one.way"))) {
                return;
            }
            Hashtable headers = new Hashtable();
            inp = this.readHeadersFromSocket(socketHolder, msgContext, inp, headers);
            this.readFromSocket(socketHolder, msgContext, inp, headers);
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw AxisFault.makeFault((Exception)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"exit00", (String)"HTTPDispatchHandler::invoke"));
        }
    }

    protected void getSocket(SocketHolder sockHolder, MessageContext msgContext, String protocol, String host, int port, int timeout, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
        SocketFactory factory;
        Hashtable<String, String> options = this.getOptions();
        if (timeout > 0) {
            if (options == null) {
                options = new Hashtable<String, String>();
            }
            options.put(DefaultSocketFactory.CONNECT_TIMEOUT, Integer.toString(timeout));
        }
        if ((factory = SocketFactoryFactory.getFactory((String)protocol, (Hashtable)options)) == null) {
            throw new IOException(Messages.getMessage((String)"noSocketFactory", (String)protocol));
        }
        Socket sock = null;
        try {
            sock = factory.create(host, port, otherHeaders, useFullURL);
        }
        catch (Exception e) {
            Thread.sleep(1000L);
            try {
                sock = factory.create(host, port, otherHeaders, useFullURL);
            }
            catch (Exception e1) {
                log.fatal((Object)("Axis client Failed: connect on socket: " + host + ":" + port), (Throwable)e);
                throw e;
            }
        }
        if (timeout > 0) {
            sock.setSoTimeout(timeout);
        }
        sockHolder.setSocket(sock);
    }

    private InputStream writeToSocket(SocketHolder sockHolder, MessageContext msgContext, URL tmpURL, StringBuffer otherHeaders, String host, int port, int timeout, BooleanHolder useFullURL) throws Exception {
        Hashtable userHeaderTable;
        String action;
        String userID = msgContext.getUsername();
        String passwd = msgContext.getPassword();
        String string = action = msgContext.useSOAPAction() ? msgContext.getSOAPActionURI() : "";
        if (action == null) {
            action = "";
        }
        if (userID == null && tmpURL.getUserInfo() != null) {
            String info = tmpURL.getUserInfo();
            int sep = info.indexOf(58);
            if (sep >= 0 && sep + 1 < info.length()) {
                userID = info.substring(0, sep);
                passwd = info.substring(sep + 1);
            } else {
                userID = info;
            }
        }
        if (userID != null) {
            StringBuffer tmpBuf = new StringBuffer(64);
            tmpBuf.append(userID).append(":").append(passwd == null ? "" : passwd);
            otherHeaders.append("Authorization").append(": Basic ").append(Base64.encode((byte[])tmpBuf.toString().getBytes())).append("\r\n");
        }
        if (msgContext.getMaintainSession()) {
            String cookie = msgContext.getStrProp("Cookie");
            String cookie2 = msgContext.getStrProp("Cookie2");
            if (cookie != null) {
                otherHeaders.append("Cookie").append(": ").append(cookie).append("\r\n");
            }
            if (cookie2 != null) {
                otherHeaders.append("Cookie2").append(": ").append(cookie2).append("\r\n");
            }
        }
        StringBuffer header2 = new StringBuffer(64);
        String webMethod = null;
        boolean posting = true;
        Message reqMessage = msgContext.getRequestMessage();
        boolean http10 = true;
        boolean httpChunkStream = false;
        boolean httpContinueExpected = false;
        String httpConnection = null;
        String httpver = msgContext.getStrProp("axis.transport.version");
        if (null == httpver) {
            httpver = HTTPConstants.HEADER_PROTOCOL_V10;
        }
        if ((httpver = httpver.trim()).equals(HTTPConstants.HEADER_PROTOCOL_V11)) {
            http10 = false;
        }
        if ((userHeaderTable = (Hashtable)msgContext.getProperty("HTTP-Request-Headers")) != null) {
            if (null == otherHeaders) {
                otherHeaders = new StringBuffer(1024);
            }
            Iterator e = userHeaderTable.entrySet().iterator();
            while (e.hasNext()) {
                String val;
                Map.Entry me = e.next();
                Object keyObj = me.getKey();
                if (null == keyObj) continue;
                String key = keyObj.toString().trim();
                if (key.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING)) {
                    if (http10 || null == (val = me.getValue().toString()) || !val.trim().equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) continue;
                    httpChunkStream = true;
                    continue;
                }
                if (key.equalsIgnoreCase("Connection")) {
                    if (http10 || !(val = me.getValue().toString()).trim().equalsIgnoreCase(HTTPConstants.HEADER_CONNECTION_CLOSE)) continue;
                    httpConnection = HTTPConstants.HEADER_CONNECTION_CLOSE;
                    continue;
                }
                if (!http10 && key.equalsIgnoreCase("Expect") && null != (val = me.getValue().toString()) && val.trim().equalsIgnoreCase("100-continue")) {
                    httpContinueExpected = true;
                }
                otherHeaders.append(key).append(": ").append(me.getValue()).append("\r\n");
            }
        }
        if (!http10) {
            httpConnection = HTTPConstants.HEADER_CONNECTION_CLOSE;
        }
        header2.append(" ");
        header2.append(http10 ? "HTTP/1.0" : "HTTP/1.1").append("\r\n");
        MimeHeaders mimeHeaders = reqMessage.getMimeHeaders();
        if (posting) {
            String contentType = mimeHeaders.getHeader("Content-Type") != null ? mimeHeaders.getHeader("Content-Type")[0] : reqMessage.getContentType(msgContext.getSOAPConstants());
            header2.append("Content-Type").append(": ").append(contentType).append("\r\n");
        }
        header2.append(ACCEPT_HEADERS).append("Host").append(": ").append(host).append(port == -1 ? "" : ":" + port).append("\r\n").append(CACHE_HEADERS).append("SOAPAction").append(": \"").append(action).append("\"\r\n");
        if (posting) {
            if (!httpChunkStream) {
                header2.append("Content-Length").append(": ").append(reqMessage.getContentLength()).append("\r\n");
            } else {
                header2.append(CHUNKED_HEADER);
            }
        }
        if (mimeHeaders != null) {
            Iterator i = mimeHeaders.getAllHeaders();
            while (i.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)i.next();
                String headerName = mimeHeader.getName();
                if (headerName.equals("Content-Type") || headerName.equals("SOAPAction")) continue;
                header2.append(mimeHeader.getName()).append(": ").append(mimeHeader.getValue()).append("\r\n");
            }
        }
        if (null != httpConnection) {
            header2.append("Connection");
            header2.append(": ");
            header2.append(httpConnection);
            header2.append("\r\n");
        }
        this.getSocket(sockHolder, msgContext, this.targetURL.getProtocol(), host, port, timeout, otherHeaders, useFullURL);
        if (null != otherHeaders) {
            header2.append(otherHeaders.toString());
        }
        header2.append("\r\n");
        StringBuffer header = new StringBuffer(128);
        if (msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS) {
            webMethod = msgContext.getStrProp("soap12.webmethod");
        }
        if (webMethod == null) {
            webMethod = "POST";
        } else {
            posting = webMethod.equals("POST");
        }
        header.append(webMethod).append(" ");
        if (useFullURL.value) {
            header.append(tmpURL.toExternalForm());
        } else {
            header.append(StringUtils.isEmpty((String)tmpURL.getFile()) ? "/" : tmpURL.getFile());
        }
        header.append(header2.toString());
        OutputStream out = sockHolder.getSocket().getOutputStream();
        if (!posting) {
            out.write(header.toString().getBytes("iso-8859-1"));
            out.flush();
            return null;
        }
        InputStream inp = null;
        if (httpChunkStream || httpContinueExpected) {
            out.write(header.toString().getBytes("iso-8859-1"));
        }
        if (httpContinueExpected) {
            out.flush();
            Hashtable cheaders = new Hashtable();
            inp = this.readHeadersFromSocket(sockHolder, msgContext, null, cheaders);
            int returnCode = -1;
            Integer Irc = (Integer)msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
            if (null != Irc) {
                returnCode = Irc;
            }
            if (100 == returnCode) {
                msgContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                msgContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
            } else {
                String statusMessage = (String)msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                AxisFault fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
                fault.setFaultDetailString(Messages.getMessage((String)"return01", (String)String.valueOf(returnCode), (String)""));
                throw fault;
            }
        }
        ByteArrayOutputStream baos = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"xmlSent00"));
            log.debug((Object)"---------------------------------------------------");
            baos = new ByteArrayOutputStream();
        }
        if (httpChunkStream) {
            ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream(out);
            out = new BufferedOutputStream((OutputStream)chunkedOutputStream, 8192);
            try {
                if (baos != null) {
                    out = new TeeOutputStream(out, (OutputStream)baos);
                }
                reqMessage.writeTo(out);
            }
            catch (SOAPException e) {
                log.error((Object)Messages.getMessage((String)"exception00"), (Throwable)e);
            }
            out.flush();
            chunkedOutputStream.eos();
        } else {
            out = new BufferedOutputStream(out, 8192);
            try {
                if (!httpContinueExpected) {
                    out.write(header.toString().getBytes("iso-8859-1"));
                }
                if (baos != null) {
                    out = new TeeOutputStream(out, (OutputStream)baos);
                }
                reqMessage.writeTo(out);
            }
            catch (SOAPException e) {
                throw e;
            }
            finally {
                out.flush();
            }
        }
        if (log.isDebugEnabled() && baos != null) {
            log.debug((Object)(header + new String(baos.toByteArray())));
        }
        return inp;
    }

    private InputStream readHeadersFromSocket(SocketHolder sockHolder, MessageContext msgContext, InputStream inp, Hashtable headers) throws IOException {
        int b = 0;
        int len = 0;
        int colonIndex = -1;
        int returnCode = 0;
        if (null == inp) {
            inp = new BufferedInputStream(sockHolder.getSocket().getInputStream());
        }
        if (headers == null) {
            headers = new Hashtable<String, String>();
        }
        boolean readTooMuch = false;
        ByteArrayOutputStream buf = new ByteArrayOutputStream(4097);
        while (true) {
            String value;
            String name;
            if (!readTooMuch) {
                b = (byte)inp.read();
            }
            if (b == -1) break;
            readTooMuch = false;
            if (b != 13 && b != 10) {
                if (b == 58 && colonIndex == -1) {
                    colonIndex = len;
                }
                ++len;
                buf.write(b);
                continue;
            }
            if (b == 13) continue;
            if (len == 0) break;
            b = (byte)inp.read();
            readTooMuch = true;
            if (b == 32 || b == 9) continue;
            buf.close();
            byte[] hdata = buf.toByteArray();
            buf.reset();
            if (colonIndex != -1) {
                name = new String(hdata, 0, colonIndex, "iso-8859-1");
                value = new String(hdata, colonIndex + 1, len - 1 - colonIndex, "iso-8859-1");
                colonIndex = -1;
            } else {
                name = new String(hdata, 0, len, "iso-8859-1");
                value = "";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(name + value));
            }
            if (msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE) == null) {
                int start = name.indexOf(32) + 1;
                String tmp = name.substring(start).trim();
                int end = tmp.indexOf(32);
                if (end != -1) {
                    tmp = tmp.substring(0, end);
                }
                returnCode = Integer.parseInt(tmp);
                msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, (Object)new Integer(returnCode));
                msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE, (Object)name.substring(start + end + 1));
            } else {
                headers.put(name.toLowerCase(), value);
            }
            len = 0;
        }
        return inp;
    }

    private InputStream readFromSocket(SocketHolder socketHolder, MessageContext msgContext, InputStream inp, Hashtable headers) throws IOException {
        String contentLocation;
        String contentType;
        Message outMsg = null;
        Integer rc = (Integer)msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
        int returnCode = 0;
        if (rc != null) {
            returnCode = rc;
        }
        contentType = null == (contentType = (String)headers.get(HEADER_CONTENT_TYPE_LC)) ? null : contentType.trim();
        String location = (String)headers.get(HEADER_LOCATION_LC);
        String string = location = null == location ? null : location.trim();
        if (returnCode > 199 && returnCode < 300) {
            if (returnCode == 202) {
                return inp;
            }
        } else if (msgContext.getSOAPConstants() != SOAPConstants.SOAP12_CONSTANTS && (contentType == null || contentType.startsWith("text/html") || returnCode <= 499 || returnCode >= 600)) {
            byte b;
            if (location != null && (returnCode == 302 || returnCode == 307)) {
                inp.close();
                socketHolder.getSocket().close();
                msgContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                msgContext.setProperty("transport.url", (Object)location);
                this.invoke(msgContext);
                return inp;
            }
            if (returnCode == 100) {
                msgContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                msgContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                this.readHeadersFromSocket(socketHolder, msgContext, inp, headers);
                return this.readFromSocket(socketHolder, msgContext, inp, headers);
            }
            ByteArrayOutputStream buf = new ByteArrayOutputStream(4097);
            while (-1 != (b = (byte)inp.read())) {
                buf.write((int)b);
            }
            String statusMessage = msgContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
            AxisFault fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
            fault.setFaultDetailString(Messages.getMessage((String)"return01", (String)String.valueOf(returnCode), (String)buf.toString()));
            fault.addFaultDetail(Constants.QNAME_FAULTDETAIL_HTTPERRORCODE, Integer.toString(returnCode));
            throw fault;
        }
        contentLocation = null == (contentLocation = (String)headers.get(HEADER_CONTENT_LOCATION_LC)) ? null : contentLocation.trim();
        String contentLength = (String)headers.get(HEADER_CONTENT_LENGTH_LC);
        contentLength = null == contentLength ? null : contentLength.trim();
        String transferEncoding = (String)headers.get(HEADER_TRANSFER_ENCODING_LC);
        if (null != transferEncoding && (transferEncoding = transferEncoding.trim().toLowerCase()).equals(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) {
            inp = new ChunkedInputStream(inp);
        }
        outMsg = new Message((Object)new SocketInputStream(inp, socketHolder.getSocket()), false, contentType, contentLocation);
        MimeHeaders mimeHeaders = outMsg.getMimeHeaders();
        Enumeration e = headers.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            mimeHeaders.addHeader(key, ((String)headers.get(key)).trim());
        }
        outMsg.setMessageType("response");
        msgContext.setResponseMessage(outMsg);
        if (log.isDebugEnabled()) {
            if (null == contentLength) {
                log.debug((Object)(SystemUtils.LINE_SEPARATOR + Messages.getMessage((String)"no00", (String)"Content-Length")));
            }
            log.debug((Object)(SystemUtils.LINE_SEPARATOR + Messages.getMessage((String)"xmlRecd00")));
            log.debug((Object)"-----------------------------------------------");
            log.debug((Object)outMsg.getSOAPEnvelope().toString());
        }
        if (msgContext.getMaintainSession()) {
            this.handleCookie("Cookie", "Set-Cookie", headers, msgContext);
            this.handleCookie("Cookie2", "Set-Cookie2", headers, msgContext);
        }
        return inp;
    }

    public void handleCookie(String cookieName, String setCookieName, Hashtable headers, MessageContext msgContext) {
        if (headers.containsKey(setCookieName.toLowerCase())) {
            String cookie = (String)headers.get(setCookieName.toLowerCase());
            int index = (cookie = cookie.trim()).indexOf(59);
            if (index != -1) {
                cookie = cookie.substring(0, index);
            }
            msgContext.setProperty(cookieName, (Object)cookie);
        }
    }
}

