/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis.extensions;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.Holder;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.constants.Enum;
import org.apache.axis.constants.Style;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCHeaderParam;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.providers.java.RPCProvider;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.mule.MuleServer;
import org.mule.impl.RequestContext;
import org.mule.providers.soap.ServiceProxy;
import org.mule.providers.soap.axis.AxisConnector;
import org.mule.providers.soap.axis.AxisMessageReceiver;
import org.mule.providers.soap.axis.AxisServiceProxy;
import org.mule.umo.UMOComponent;

public class MuleRPCProvider
extends RPCProvider {
    private static final long serialVersionUID = -4987111047650933518L;
    private AxisConnector connector;

    public MuleRPCProvider(AxisConnector connector) {
        this.connector = connector;
    }

    protected Object makeNewServiceObject(MessageContext messageContext, String s) throws Exception {
        AxisMessageReceiver receiver;
        String transUrl = (String)messageContext.getProperty("transport.url");
        int i = transUrl.indexOf("?");
        if (i > -1) {
            transUrl = transUrl.substring(0, i);
        }
        if ((receiver = (AxisMessageReceiver)this.connector.lookupReceiver(transUrl)) == null) {
            receiver = (AxisMessageReceiver)this.connector.lookupReceiver(messageContext.getTargetService());
        }
        if (receiver == null) {
            throw new AxisFault("Could not find Mule registered service: " + s);
        }
        Class[] classes = ServiceProxy.getInterfacesForComponent((UMOComponent)receiver.getComponent());
        return AxisServiceProxy.createProxy(receiver, true, classes);
    }

    protected Class getServiceClass(String s, SOAPService soapService, MessageContext messageContext) throws AxisFault {
        UMOComponent component = MuleServer.getManagementContext().getRegistry().lookupComponent(soapService.getName());
        try {
            Class[] classes = ServiceProxy.getInterfacesForComponent((UMOComponent)component);
            return Proxy.getProxyClass(Thread.currentThread().getContextClassLoader(), classes);
        }
        catch (Exception e) {
            throw new AxisFault("Failed to implementation class for component: " + e.getMessage(), (Throwable)e);
        }
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        super.invoke(msgContext);
        if (RequestContext.getExceptionPayload() != null) {
            Throwable t = RequestContext.getExceptionPayload().getException();
            if (t instanceof Exception) {
                AxisFault fault = AxisFault.makeFault((Exception)((Exception)t));
                if (t instanceof RuntimeException) {
                    fault.addFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION, "true");
                }
                throw fault;
            }
            throw (Error)t;
        }
    }

    protected RPCElement createResponseBody(RPCElement body, MessageContext msgContext, OperationDesc operation, ServiceDesc serviceDesc, Object objRes, SOAPEnvelope resEnv, ArrayList outs) throws Exception {
        RPCParam param;
        String methodName = operation.getName();
        RPCElement resBody = new RPCElement(methodName + "Response");
        resBody.setPrefix(body.getPrefix());
        resBody.setNamespaceURI(body.getNamespaceURI());
        resBody.setEncodingStyle(msgContext.getEncodingStyle());
        if (operation.getMethod().getReturnType() != Void.TYPE) {
            QName returnQName = operation.getReturnQName();
            if (returnQName == null) {
                String nsp = body.getNamespaceURI();
                if (nsp == null || nsp.length() == 0) {
                    nsp = serviceDesc.getDefaultNamespace();
                }
                returnQName = new QName(msgContext.isEncoded() ? "" : nsp, methodName + "Return");
            }
            param = new RPCParam(returnQName, objRes);
            param.setParamDesc(operation.getReturnParamDesc());
            if (!operation.isReturnHeader()) {
                if (msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS && serviceDesc.getStyle().equals((Enum)Style.RPC)) {
                    RPCParam resultParam = new RPCParam(Constants.QNAME_RPC_RESULT, (Object)returnQName);
                    resultParam.setXSITypeGeneration(Boolean.FALSE);
                    resBody.addParam(resultParam);
                }
                resBody.addParam(param);
            } else {
                resEnv.addHeader((SOAPHeaderElement)new RPCHeaderParam(param));
            }
        }
        if (!outs.isEmpty()) {
            Iterator i = outs.iterator();
            while (i.hasNext()) {
                param = (RPCParam)i.next();
                Holder holder = (Holder)param.getObjectValue();
                Object value = JavaUtils.getHolderValue((Object)holder);
                ParameterDesc paramDesc = param.getParamDesc();
                param.setObjectValue(value);
                if (paramDesc != null && paramDesc.isOutHeader()) {
                    resEnv.addHeader((SOAPHeaderElement)new RPCHeaderParam(param));
                    continue;
                }
                resBody.addParam(param);
            }
        }
        return resBody;
    }
}

