/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import java.util.Iterator;
import java.util.Properties;
import org.apache.axis.AxisProperties;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.message.SOAPEnvelope;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.soap.axis.AxisConnector;
import org.mule.transport.soap.axis.AxisMessageDispatcher;

public class AxisMessageRequester
extends AbstractMessageRequester {
    protected EngineConfiguration clientConfig;
    protected AxisConnector connector;
    protected Service service;

    public AxisMessageRequester(ImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (AxisConnector)endpoint.getConnector();
        AxisProperties.setProperty((String)"axis.doAutoTypes", (String)Boolean.toString(this.connector.isDoAutoTypes()));
    }

    protected void doConnect() throws Exception {
        if (this.service == null) {
            this.service = this.createService(this.endpoint);
        }
    }

    protected void doDisconnect() throws Exception {
        if (this.service != null) {
            this.service = null;
        }
    }

    protected void doDispose() {
    }

    protected synchronized EngineConfiguration getClientConfig(ImmutableEndpoint endpoint) {
        if (this.clientConfig == null) {
            String config = (String)endpoint.getProperty((Object)"clientConfig");
            this.clientConfig = config != null ? new FileProvider(config) : this.connector.getClientProvider();
        }
        return this.clientConfig;
    }

    protected Service createService(ImmutableEndpoint endpoint) throws Exception {
        EngineConfiguration config = this.getClientConfig(endpoint);
        return new Service(config);
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        Call call = new Call(this.service);
        String uri = this.endpoint.getEndpointURI().toString();
        call.setSOAPActionURI(uri);
        call.setTargetEndpointAddress(uri);
        Properties params = this.endpoint.getEndpointURI().getUserParams();
        String method = (String)params.remove("method");
        call.setOperationName(method);
        Object[] args = new String[params.size()];
        int i = 0;
        Iterator<Object> iterator = params.values().iterator();
        while (iterator.hasNext()) {
            args[i] = iterator.next().toString();
            ++i;
        }
        call.setOperationName(method);
        call.setProperty("MULE_ENDPOINT", (Object)this.endpoint);
        Object result = call.invoke(method, args);
        return AxisMessageDispatcher.createMessage(result, call);
    }

    public MuleMessage request(String endpoint, Object[] args) throws Exception {
        Call call = new Call(this.service);
        call.setSOAPActionURI(endpoint);
        call.setTargetEndpointAddress(endpoint);
        if (!endpoint.startsWith("axis:")) {
            endpoint = "axis:" + endpoint;
        }
        MuleEndpointURI ep = new MuleEndpointURI(endpoint);
        String method = (String)ep.getParams().remove("method");
        call.setOperationName(method);
        call.setOperationName(method);
        Object result = call.invoke(method, args);
        return AxisMessageDispatcher.createMessage(result, call);
    }

    public MuleMessage request(String endpoint, javax.xml.soap.SOAPEnvelope envelope) throws Exception {
        Call call = new Call(this.service);
        call.setSOAPActionURI(endpoint);
        call.setTargetEndpointAddress(endpoint);
        SOAPEnvelope result = call.invoke(new Message((Object)envelope));
        return AxisMessageDispatcher.createMessage(result, call);
    }
}

