/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Call;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.deployment.wsdd.WSDDProvider;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.server.AxisServer;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.fromJava.Types;
import org.mule.api.MuleException;
import org.mule.api.component.Component;
import org.mule.api.config.ExceptionReader;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.object.ObjectFactory;
import org.mule.api.service.Service;
import org.mule.api.transport.MessageReceiver;
import org.mule.component.DefaultJavaComponent;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.model.seda.SedaService;
import org.mule.object.SingletonObjectFactory;
import org.mule.transport.AbstractConnector;
import org.mule.transport.http.servlet.ServletConnector;
import org.mule.transport.service.TransportFactory;
import org.mule.transport.soap.axis.AxisFaultExceptionReader;
import org.mule.transport.soap.axis.AxisMessageReceiver;
import org.mule.transport.soap.axis.AxisServiceComponent;
import org.mule.transport.soap.axis.extensions.MuleConfigProvider;
import org.mule.transport.soap.axis.extensions.MuleTransport;
import org.mule.transport.soap.axis.extensions.WSDDFileProvider;
import org.mule.transport.soap.axis.extensions.WSDDJavaMuleProvider;
import org.mule.transport.soap.axis.i18n.AxisMessages;
import org.mule.transport.soap.axis.transport.jms.Handler;
import org.mule.util.ClassUtils;
import org.mule.util.MuleUrlStreamHandlerFactory;

public class AxisConnector
extends AbstractConnector
implements MuleContextNotificationListener {
    public static final QName QNAME_MULE_PROVIDER;
    public static final QName QNAME_MULE_TYPE_MAPPINGS;
    public static final String DEFAULT_MULE_NAMESPACE_URI = "http://www.muleumo.org";
    public static final String DEFAULT_MULE_AXIS_SERVER_CONFIG = "mule-axis-server-config.wsdd";
    public static final String DEFAULT_MULE_AXIS_CLIENT_CONFIG = "mule-axis-client-config.wsdd";
    public static final String AXIS_SERVICE_COMPONENT_NAME = "_axisServiceComponent";
    public static final String AXIS_SERVICE_PROPERTY = "_axisService";
    public static final String AXIS_CLIENT_CONFIG_PROPERTY = "clientConfig";
    public static final String SERVICE_PROPERTY_COMPONENT_NAME = "componentName";
    public static final String SERVICE_PROPERTY_SERVCE_PATH = "servicePath";
    public static final String AXIS = "axis";
    public static final String SOAP_METHODS = "soapMethods";
    public static final String STYLE = "style";
    public static final String USE = "use";
    private String serverConfig = "mule-axis-server-config.wsdd";
    private AxisServer axis = null;
    private SimpleProvider serverProvider = null;
    private String clientConfig = "mule-axis-client-config.wsdd";
    private SimpleProvider clientProvider = null;
    private List beanTypes;
    private Service axisComponent;
    private Map axisTransportProtocols = null;
    private List servletServices = new ArrayList();
    private List supportedSchemes = null;
    private boolean doAutoTypes = true;
    private boolean treatMapAsNamedParams = true;

    public AxisConnector() {
        this.registerProtocols();
    }

    protected void registerProtocols() {
        if (this.supportedSchemes == null) {
            this.supportedSchemes = new ArrayList();
            this.supportedSchemes.add("http");
            this.supportedSchemes.add("https");
            this.supportedSchemes.add("servlet");
            this.supportedSchemes.add("vm");
            this.supportedSchemes.add("jms");
            this.supportedSchemes.add("xmpp");
            this.supportedSchemes.add("ssl");
            this.supportedSchemes.add("tcp");
            this.supportedSchemes.add("smtp");
            this.supportedSchemes.add("smtps");
            this.supportedSchemes.add("pop3");
            this.supportedSchemes.add("pop3s");
            this.supportedSchemes.add("imap");
            this.supportedSchemes.add("imaps");
        }
        for (String s : this.supportedSchemes) {
            this.registerSupportedProtocol(s);
        }
    }

    protected void doInitialise() throws InitialisationException {
        this.axisTransportProtocols = new HashMap();
        this.axisTransportProtocols = new HashMap();
        try {
            for (String s : this.supportedSchemes) {
                this.axisTransportProtocols.put(s, MuleTransport.getTransportClass(s));
                this.registerSupportedProtocol(s);
            }
            this.muleContext.registerListener((ServerNotificationListener)this);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        if (this.clientProvider == null) {
            this.clientProvider = this.createAxisProvider(this.clientConfig);
        } else if (!DEFAULT_MULE_AXIS_CLIENT_CONFIG.equals(this.clientConfig)) {
            this.logger.warn((Object)AxisMessages.clientProviderAndClientConfigConfigured());
        }
        if (this.axis == null) {
            if (this.serverProvider == null) {
                this.serverProvider = this.createAxisProvider(this.serverConfig);
            } else if (!DEFAULT_MULE_AXIS_SERVER_CONFIG.equals(this.serverConfig)) {
                this.logger.warn((Object)AxisMessages.serverProviderAndServerConfigConfigured());
            }
            this.axis = new AxisServer((EngineConfiguration)this.serverProvider);
            this.axis.setOption("axis.doAutoTypes", (Object)this.doAutoTypes);
        }
        WSDDProvider.registerProvider((QName)QNAME_MULE_PROVIDER, (WSDDProvider)new WSDDJavaMuleProvider(this));
        try {
            this.registerTransportTypes();
        }
        catch (ClassNotFoundException e) {
            throw new InitialisationException(CoreMessages.cannotLoadFromClasspath((String)e.getMessage()), (Throwable)e, (Initialisable)this);
        }
        MuleUrlStreamHandlerFactory.registerHandler((String)"jms", (URLStreamHandler)new Handler());
        MuleUrlStreamHandlerFactory.registerHandler((String)"pop3", (URLStreamHandler)new org.mule.transport.soap.axis.transport.pop3.Handler());
        MuleUrlStreamHandlerFactory.registerHandler((String)"smtp", (URLStreamHandler)new org.mule.transport.soap.axis.transport.smtp.Handler());
        MuleUrlStreamHandlerFactory.registerHandler((String)"vm", (URLStreamHandler)new org.mule.transport.soap.axis.transport.vm.Handler());
        try {
            this.registerTypes((TypeMappingRegistryImpl)this.axis.getTypeMappingRegistry(), this.beanTypes);
        }
        catch (ClassNotFoundException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void registerTransportTypes() throws ClassNotFoundException {
        for (String protocol : this.getAxisTransportProtocols().keySet()) {
            Object temp = this.getAxisTransportProtocols().get(protocol);
            Class clazz = temp instanceof String ? ClassUtils.loadClass((String)temp.toString(), ((Object)((Object)this)).getClass()) : (Class)temp;
            Call.setTransportForProtocol((String)protocol, (Class)clazz);
        }
    }

    protected SimpleProvider createAxisProvider(String config) throws InitialisationException {
        WSDDFileProvider fileProvider = new WSDDFileProvider(config);
        fileProvider.setSearchClasspath(true);
        return new MuleConfigProvider((EngineConfiguration)fileProvider);
    }

    public String getProtocol() {
        return AXIS;
    }

    protected Object getReceiverKey(Service component, InboundEndpoint endpoint) {
        if (endpoint.getEndpointURI().getPort() == -1) {
            return component.getName();
        }
        return endpoint.getEndpointURI().getAddress() + "/" + component.getName();
    }

    protected void unregisterReceiverWithMuleService(MessageReceiver receiver, EndpointURI ep) throws MuleException {
        String endpointKey = this.getCounterEndpointKey(receiver.getEndpointURI());
        for (ImmutableEndpoint umoEndpoint : this.axisComponent.getInboundRouter().getEndpoints()) {
            if (endpointKey.startsWith(umoEndpoint.getEndpointURI().getAddress())) {
                this.logger.info((Object)("Unregistering Axis endpoint: " + endpointKey + " for service: " + ((AxisMessageReceiver)receiver).getSoapService().getName()));
            }
            try {
                umoEndpoint.getConnector().unregisterListener(receiver.getService(), receiver.getEndpoint());
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to unregister Axis endpoint: " + endpointKey + " for service: " + receiver.getService().getName() + ". Error is: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void registerReceiverWithMuleService(MessageReceiver receiver, EndpointURI ep) throws MuleException {
        if (this.axisComponent == null) {
            this.axisComponent = this.getOrCreateAxisComponent();
        } else {
            this.muleContext.getRegistry().unregisterService(AXIS_SERVICE_PROPERTY + this.getName());
        }
        String serviceName = ((AxisMessageReceiver)receiver).getSoapService().getName();
        String scheme = ep.getScheme().toLowerCase();
        String endpoint = scheme.equals("jms") || scheme.equals("vm") ? ep.toString() : receiver.getEndpointURI().getAddress() + "/" + serviceName;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Modified endpoint with " + scheme + " scheme to " + endpoint));
        }
        boolean sync = receiver.getEndpoint().isSynchronous();
        EndpointURIEndpointBuilder serviceEndpointbuilder = new EndpointURIEndpointBuilder(endpoint, this.muleContext);
        serviceEndpointbuilder.setSynchronous(sync);
        serviceEndpointbuilder.setName(ep.getScheme() + ":" + serviceName);
        serviceEndpointbuilder.setTransformers(receiver.getEndpoint().getTransformers().isEmpty() ? null : receiver.getEndpoint().getTransformers());
        serviceEndpointbuilder.setResponseTransformers(receiver.getEndpoint().getResponseTransformers().isEmpty() ? null : receiver.getEndpoint().getResponseTransformers());
        serviceEndpointbuilder.setFilter(receiver.getEndpoint().getFilter());
        serviceEndpointbuilder.setSecurityFilter(receiver.getEndpoint().getSecurityFilter());
        EndpointURIEndpointBuilder receiverEndpointBuilder = new EndpointURIEndpointBuilder((ImmutableEndpoint)receiver.getEndpoint(), this.muleContext);
        receiverEndpointBuilder.setFilter(null);
        receiverEndpointBuilder.setSecurityFilter(null);
        InboundEndpoint serviceEndpoint = this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint((EndpointBuilder)serviceEndpointbuilder);
        InboundEndpoint receiverEndpoint = this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint((EndpointBuilder)receiverEndpointBuilder);
        receiver.setEndpoint(receiverEndpoint);
        this.axisComponent.getInboundRouter().addEndpoint(serviceEndpoint);
    }

    private String getCounterEndpointKey(EndpointURI endpointURI) {
        StringBuffer endpointKey = new StringBuffer(64);
        endpointKey.append(endpointURI.getScheme());
        endpointKey.append("://");
        endpointKey.append(endpointURI.getHost());
        if (endpointURI.getPort() > -1) {
            endpointKey.append(":");
            endpointKey.append(endpointURI.getPort());
        }
        return endpointKey.toString();
    }

    protected Service getOrCreateAxisComponent() throws MuleException {
        Service c = this.muleContext.getRegistry().lookupService(AXIS_SERVICE_PROPERTY + this.getName());
        if (c == null) {
            c = new SedaService();
            c.setName(AXIS_SERVICE_PROPERTY + this.getName());
            c.setModel(this.muleContext.getRegistry().lookupSystemModel());
            HashMap<String, AxisServer> props = new HashMap<String, AxisServer>();
            props.put(AXIS, this.axis);
            SingletonObjectFactory of = new SingletonObjectFactory(AxisServiceComponent.class, props);
            of.initialise();
            c.setComponent((Component)new DefaultJavaComponent((ObjectFactory)of));
        }
        return c;
    }

    protected void doStart() throws MuleException {
        this.axis.start();
    }

    protected void doStop() throws MuleException {
        this.axis.stop();
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
    }

    public List getBeanTypes() {
        return this.beanTypes;
    }

    public void setBeanTypes(List beanTypes) {
        this.beanTypes = beanTypes;
    }

    public String getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(String clientConfig) {
        this.clientConfig = clientConfig;
    }

    public AxisServer getAxis() {
        return this.axis;
    }

    public void setAxis(AxisServer axisServer) {
        this.axis = axisServer;
    }

    public SimpleProvider getServerProvider() {
        return this.serverProvider;
    }

    public void setServerProvider(SimpleProvider serverProvider) {
        this.serverProvider = serverProvider;
    }

    public SimpleProvider getClientProvider() {
        return this.clientProvider;
    }

    public void setClientProvider(SimpleProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    public Map getAxisTransportProtocols() {
        return this.axisTransportProtocols;
    }

    public void setAxisTransportProtocols(Map axisTransportProtocols) {
        this.axisTransportProtocols.putAll(axisTransportProtocols);
    }

    void addServletService(SOAPService service) {
        this.servletServices.add(service);
    }

    public List getSupportedSchemes() {
        return this.supportedSchemes;
    }

    public void setSupportedSchemes(List supportedSchemes) {
        this.supportedSchemes = supportedSchemes;
    }

    public boolean isDoAutoTypes() {
        return this.doAutoTypes;
    }

    public void setDoAutoTypes(boolean doAutoTypes) {
        this.doAutoTypes = doAutoTypes;
    }

    void registerTypes(TypeMappingRegistryImpl registry, List types) throws ClassNotFoundException {
        if (types != null) {
            Iterator iterator = types.iterator();
            while (iterator.hasNext()) {
                Class clazz = ClassUtils.loadClass((String)iterator.next().toString(), ((Object)((Object)this)).getClass());
                String localName = Types.getLocalNameFromFullName((String)clazz.getName());
                QName xmlType = new QName(Namespaces.makeNamespace((String)clazz.getName()), localName);
                registry.getDefaultTypeMapping().register(clazz, xmlType, (SerializerFactory)new BeanSerializerFactory(clazz, xmlType), (DeserializerFactory)new BeanDeserializerFactory(clazz, xmlType));
            }
        }
    }

    public boolean isTreatMapAsNamedParams() {
        return this.treatMapAsNamedParams;
    }

    public void setTreatMapAsNamedParams(boolean treatMapAsNamedParams) {
        this.treatMapAsNamedParams = treatMapAsNamedParams;
    }

    public void onNotification(ServerNotification notification) {
        if (notification.getAction() == 104 && this.muleContext.getRegistry().lookupService(AXIS_SERVICE_PROPERTY + this.getName()) == null) {
            try {
                if (this.axisComponent == null) {
                    this.axisComponent = this.getOrCreateAxisComponent();
                }
                this.muleContext.getRegistry().registerService(this.axisComponent);
                for (SOAPService service : this.servletServices) {
                    ServletConnector servletConnector = (ServletConnector)TransportFactory.getConnectorByProtocol((String)"servlet");
                    String url = servletConnector.getServletUrl();
                    if (url != null) {
                        service.getServiceDescription().setEndpointURL(url + "/" + service.getName());
                        continue;
                    }
                    this.logger.error((Object)("The servletUrl property on the ServletConntector has not been set this means that wsdl generation for service '" + service.getName() + "' may be incorrect"));
                }
                this.servletServices.clear();
            }
            catch (MuleException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    public boolean isSyncEnabled(String protocol) {
        if ((protocol = protocol.toLowerCase()).equals("http") || protocol.equals("https") || protocol.equals("ssl") || protocol.equals("tcp") || protocol.equals("servlet")) {
            return true;
        }
        return super.isSyncEnabled(protocol);
    }

    static {
        ExceptionHelper.registerExceptionReader((ExceptionReader)new AxisFaultExceptionReader());
        QNAME_MULE_PROVIDER = new QName("http://xml.apache.org/axis/wsdd/providers/java", "Mule");
        QNAME_MULE_TYPE_MAPPINGS = new QName("http://www.muleumo.org/ws/mappings", "Mule");
    }
}

