/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis.extensions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.handlers.BasicHandler;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MuleServer;
import org.mule.RegistryContext;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.transport.soap.axis.AxisConnector;
import org.mule.transport.soap.axis.extras.AxisCleanAndAddProperties;

public class UniversalSender
extends BasicHandler {
    private static final long serialVersionUID = 7943380365092172940L;
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected Map endpointsCache = new HashMap();

    public void invoke(MessageContext msgContext) throws AxisFault {
        OutboundEndpoint endpoint;
        boolean sync = true;
        Call call = (Call)msgContext.getProperty("call_object");
        if (call == null) {
            throw new IllegalStateException("The call_object property must be set on the message context to the client Call object");
        }
        if (Boolean.TRUE.equals(call.getProperty("axis.one.way"))) {
            sync = false;
        }
        String uri = msgContext.getStrProp("transport.url");
        ImmutableEndpoint requestEndpoint = (ImmutableEndpoint)call.getProperty("MULE_ENDPOINT");
        if (msgContext.getUsername() != null) {
            String[] tempEndpoint = uri.split("//");
            String credentialString = msgContext.getUsername() + ":" + msgContext.getPassword();
            uri = tempEndpoint[0] + "//" + credentialString + "@" + tempEndpoint[1];
            try {
                endpoint = this.lookupEndpoint(uri);
            }
            catch (MuleException e) {
                requestEndpoint.getConnector().handleException((Exception)((Object)e));
                return;
            }
        }
        try {
            endpoint = this.lookupEndpoint(uri);
        }
        catch (MuleException e) {
            requestEndpoint.getConnector().handleException((Exception)((Object)e));
            return;
        }
        try {
            String scheme;
            if (requestEndpoint.getConnector() instanceof AxisConnector) {
                msgContext.setTypeMappingRegistry(((AxisConnector)requestEndpoint.getConnector()).getAxis().getTypeMappingRegistry());
            }
            Map<String, String> props = new HashMap();
            Object payload = null;
            int contentLength = 0;
            String contentType = null;
            if (msgContext.getRequestMessage().countAttachments() > 0) {
                File temp = File.createTempFile("soap", ".tmp");
                temp.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(temp);
                msgContext.getRequestMessage().writeTo((OutputStream)fos);
                fos.close();
                contentLength = (int)temp.length();
                payload = new FileInputStream(temp);
                contentType = "multipart/related";
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
                msgContext.getRequestMessage().writeTo((OutputStream)baos);
                baos.close();
                payload = baos.toByteArray();
            }
            Iterator iterator = msgContext.getPropertyNames();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                if (name.equals("call_object") || name.equals("wsdl.service")) continue;
                props.put(name, (String)msgContext.getProperty(name));
            }
            if (RequestContext.getEvent() != null && RequestContext.getEvent().getMessage() != null) {
                props = AxisCleanAndAddProperties.cleanAndAdd(RequestContext.getEventContext());
            }
            if (!"vm".equalsIgnoreCase(scheme = requestEndpoint.getEndpointURI().getScheme()) && !"jms".equalsIgnoreCase(scheme)) {
                if (call.useSOAPAction()) {
                    uri = call.getSOAPActionURI();
                }
                props.put("SOAPAction", uri);
            }
            if (contentLength > 0) {
                props.put("Content-Length", Integer.toString(contentLength));
            }
            if (props.get("Content-Type") == null) {
                if (contentType == null) {
                    contentType = "text/xml";
                }
                props.put("Content-Type", contentType);
            }
            DefaultMuleMessage message = new DefaultMuleMessage(payload, props);
            MuleSession session = RequestContext.getEventContext().getSession();
            this.logger.info((Object)("Making Axis soap request on: " + uri));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Soap request is:\n" + new String(payload instanceof byte[] ? (byte[])payload : payload.toString().getBytes())));
            }
            if (sync) {
                MuleContext muleContext = MuleServer.getMuleContext();
                EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder((ImmutableEndpoint)endpoint, muleContext);
                builder.setRemoteSync(true);
                OutboundEndpoint syncEndpoint = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint((EndpointBuilder)builder);
                DefaultMuleEvent dispatchEvent = new DefaultMuleEvent((MuleMessage)message, (ImmutableEndpoint)syncEndpoint, session, sync);
                MuleMessage result = endpoint.send((MuleEvent)dispatchEvent);
                if (result != null) {
                    byte[] response = result.getPayloadAsBytes();
                    Message responseMessage = new Message((Object)response);
                    msgContext.setResponseMessage(responseMessage);
                } else {
                    this.logger.warn((Object)("No response message was returned from synchronous call to: " + uri));
                }
                if (payload instanceof File) {
                    ((File)payload).delete();
                }
            } else {
                DefaultMuleEvent dispatchEvent = new DefaultMuleEvent((MuleMessage)message, (ImmutableEndpoint)endpoint, session, sync);
                endpoint.dispatch((MuleEvent)dispatchEvent);
            }
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage(), new Throwable(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutboundEndpoint lookupEndpoint(String uri) throws MuleException {
        OutboundEndpoint ep;
        Service axis = RegistryContext.getRegistry().lookupService("_axisServiceComponent");
        MuleEndpointURI endpoint = new MuleEndpointURI(uri);
        MuleContext muleContext = MuleServer.getMuleContext();
        if (axis != null) {
            Map map = this.endpointsCache;
            synchronized (map) {
                ep = (OutboundEndpoint)this.endpointsCache.get(endpoint.getAddress());
                if (ep == null) {
                    this.updateEndpointCache(axis.getOutboundRouter());
                    ep = (OutboundEndpoint)this.endpointsCache.get(endpoint.getAddress());
                    if (ep == null) {
                        this.logger.debug((Object)("Dispatch Endpoint uri: " + uri + " not found on the cache. Creating the endpoint instead."));
                        ep = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(uri);
                    } else {
                        this.logger.info((Object)("Found endpoint: " + uri + " on the Axis service component"));
                    }
                } else {
                    this.logger.info((Object)("Found endpoint: " + uri + " on the Axis service component"));
                }
            }
        } else {
            ep = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(uri);
        }
        return ep;
    }

    private void updateEndpointCache(OutboundRouterCollection router) {
        this.endpointsCache.clear();
        for (OutboundRouter r : router.getRouters()) {
            for (ImmutableEndpoint endpoint : r.getEndpoints()) {
                this.endpointsCache.put(endpoint.getEndpointURI().getAddress(), endpoint);
            }
        }
    }
}

