/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.i18n.Messages;
import org.apache.axis.security.servlet.ServletSecurityProvider;
import org.apache.axis.server.AxisServer;
import org.apache.axis.session.Session;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.transport.http.ServletEndpointContextImpl;
import org.apache.axis.utils.Admin;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.transport.WriterMessageAdapter;
import org.mule.transport.soap.axis.AxisServiceProxy;
import org.mule.transport.soap.axis.extensions.AxisMuleSession;
import org.mule.transport.soap.axis.extensions.MuleConfigProvider;
import org.mule.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AxisServiceComponent
implements Initialisable,
Callable {
    protected static final Log logger = LogFactory.getLog(AxisServiceComponent.class);
    public static final String INIT_PROPERTY_TRANSPORT_NAME = "transport.name";
    public static final String INIT_PROPERTY_USE_SECURITY = "use-servlet-security";
    public static final String INIT_PROPERTY_ENABLE_LIST = "axis.enableListQuery";
    public static final String DEFAULT_AXIS_HOME = "/axisHome";
    private String transportName = "http";
    private ServletSecurityProvider securityProvider = null;
    private boolean enableList = true;
    private String homeDir;
    private AxisServer axis;

    public Object onCall(MuleEventContext context) throws Exception {
        WriterMessageAdapter response = new WriterMessageAdapter((Object)new StringWriter(4096));
        String method = context.getMessage().getStringProperty("http.method", "POST");
        if ("GET".equalsIgnoreCase(method)) {
            this.doGet(context, response);
        } else {
            this.doPost(context, response);
        }
        response.getWriter().close();
        return new DefaultMuleMessage((Object)response, context.getMuleContext());
    }

    public void initialise() throws InitialisationException {
        if (this.axis == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"No Axis instance, this component has not been initialized properly."), (Initialisable)this);
        }
    }

    public void doGet(MuleEventContext context, WriterMessageAdapter response) throws MuleException, IOException {
        try {
            boolean hasNoPath;
            EndpointURI endpointUri = context.getEndpointURI();
            if (!"true".equalsIgnoreCase(context.getEndpointURI().getParams().getProperty("servlet.endpoint"))) {
                String uri = "soap:" + context.getEndpointURI().getScheme() + "://" + context.getEndpointURI().getHost() + ":" + context.getEndpointURI().getPort();
                uri = uri + context.getMessage().getStringProperty("http.request", "");
                endpointUri = new MuleEndpointURI(uri, context.getMuleContext());
                endpointUri.initialise();
            }
            AxisServer engine = this.getAxis();
            String pathInfo = endpointUri.getPath();
            boolean wsdlRequested = false;
            boolean listRequested = false;
            if (endpointUri.getAddress().endsWith(".jws")) {
                throw new AxisFault("Jws not supported by the Mule Axis service");
            }
            String queryString = endpointUri.getQuery();
            if (queryString != null) {
                if (queryString.equalsIgnoreCase("wsdl")) {
                    wsdlRequested = true;
                } else if (queryString.equalsIgnoreCase("list")) {
                    listRequested = true;
                }
            }
            boolean bl = hasNoPath = StringUtils.isEmpty((String)pathInfo) || pathInfo.equals("/");
            if (!wsdlRequested && !listRequested && hasNoPath) {
                this.reportAvailableServices(context, response);
            } else {
                MessageContext msgContext = new MessageContext((AxisEngine)engine);
                this.populateMessageContext(msgContext, context, endpointUri);
                msgContext.setProperty("transport.url", (Object)endpointUri.toString());
                if (wsdlRequested) {
                    this.processWsdlRequest(msgContext, response);
                } else if (listRequested) {
                    this.processListRequest(response);
                } else {
                    this.processMethodRequest(msgContext, context, response, endpointUri);
                }
            }
        }
        catch (AxisFault fault) {
            this.reportTroubleInGet((Exception)((Object)fault), response);
        }
        catch (Exception e) {
            this.reportTroubleInGet(e, response);
        }
    }

    protected void doPost(MuleEventContext context, WriterMessageAdapter response) throws Exception {
        Message responseMsg;
        AxisServer engine = this.getAxis();
        if (engine == null) {
            throw new MessagingException(CoreMessages.objectIsNull((String)"Axis Engine"), context.getMessage());
        }
        MessageContext msgContext = new MessageContext((AxisEngine)engine);
        try {
            Object request;
            EndpointURI endpointUri = context.getEndpointURI();
            this.populateMessageContext(msgContext, context, endpointUri);
            if (this.securityProvider != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("securityProvider:" + this.securityProvider));
                }
                msgContext.setProperty("securityProvider", (Object)this.securityProvider);
            }
            if ((request = context.transformMessage()) instanceof File) {
                request = new FileInputStream((File)request);
            } else if (request instanceof byte[]) {
                request = new ByteArrayInputStream((byte[])request);
            }
            Message requestMsg = new Message(request, false, context.getMessage().getStringProperty("Content-Type", null), context.getMessage().getStringProperty("Content-Location", null));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Request Message:" + requestMsg));
            }
            msgContext.setRequestMessage(requestMsg);
            msgContext.setProperty("transport.url", (Object)endpointUri.toString());
            String soapAction = this.getSoapAction(context);
            if (soapAction != null) {
                msgContext.setUseSOAPAction(true);
                msgContext.setSOAPActionURI(soapAction);
            }
            msgContext.setSession((Session)new AxisMuleSession(context.getSession()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoking Axis Engine.");
            }
            AxisServiceProxy.setProperties(RequestContext.getEvent().getEndpoint().getProperties());
            engine.invoke(msgContext);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Return from Axis Engine.");
            }
            if (RequestContext.getExceptionPayload() instanceof Exception) {
                throw (Exception)RequestContext.getExceptionPayload().getException();
            }
            if (request instanceof File) {
                ((File)request).delete();
            }
            if ((responseMsg = msgContext.getResponseMessage()) == null) {
                throw new Exception(Messages.getMessage((String)"noResponse01"));
            }
        }
        catch (AxisFault fault) {
            logger.error((Object)(fault.toString() + " target service is: " + msgContext.getTargetService() + ". MuleEvent is: " + context.toString()), (Throwable)fault);
            this.processAxisFault(fault);
            this.configureResponseFromAxisFault(response, fault);
            responseMsg = msgContext.getResponseMessage();
            if (responseMsg == null) {
                responseMsg = new Message((Object)fault);
            }
        }
        catch (Exception e) {
            responseMsg = msgContext.getResponseMessage();
            response.setProperty("http.status", (Object)"500");
            responseMsg = this.convertExceptionToAxisFault(e, responseMsg);
        }
        String contentType = responseMsg.getContentType(msgContext.getSOAPConstants());
        this.sendResponse(contentType, response, responseMsg);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Response sent.");
        }
    }

    private void reportTroubleInGet(Exception exception, WriterMessageAdapter response) {
        response.setProperty("Content-Type", (Object)"text/html");
        response.setProperty("http.status", (Object)"500");
        response.write("<h2>" + Messages.getMessage((String)"error00") + "</h2>");
        response.write("<p>" + Messages.getMessage((String)"somethingWrong00") + "</p>");
        if (exception instanceof AxisFault) {
            AxisFault fault = (AxisFault)((Object)exception);
            this.processAxisFault(fault);
            this.writeFault(response, fault);
        } else {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            response.write("<pre>Exception - " + exception + "<br>");
            response.write("</pre>");
        }
    }

    protected void processAxisFault(AxisFault fault) {
        Element runtimeException = fault.lookupFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        if (runtimeException != null) {
            logger.info((Object)Messages.getMessage((String)"axisFault00"), (Throwable)fault);
            fault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)Messages.getMessage((String)"axisFault00"), (Throwable)fault);
        }
    }

    private void writeFault(WriterMessageAdapter response, AxisFault axisFault) {
        String localizedMessage = XMLUtils.xmlEncodeString((String)axisFault.getLocalizedMessage());
        response.write("<pre>Fault - " + localizedMessage + "<br>");
        response.write(axisFault.dumpToString());
        response.write("</pre>");
    }

    protected void processMethodRequest(MessageContext msgContext, MuleEventContext context, WriterMessageAdapter response, EndpointURI endpointUri) throws AxisFault {
        Properties params = endpointUri.getUserParams();
        String method = (String)params.remove("method");
        if (method == null) {
            method = endpointUri.getPath().substring(endpointUri.getPath().lastIndexOf("/") + 1);
        }
        StringBuffer args = new StringBuffer(64);
        for (Map.Entry<Object, Object> entry : params.entrySet()) {
            args.append("<").append(entry.getKey()).append(">");
            args.append(entry.getValue());
            args.append("</").append(entry.getKey()).append(">");
        }
        if (method == null) {
            response.setProperty("Content-Type", (Object)"text/html");
            response.setProperty("http.status", (Object)"400");
            response.write("<h2>" + Messages.getMessage((String)"error00") + ":  " + Messages.getMessage((String)"invokeGet00") + "</h2>");
            response.write("<p>" + Messages.getMessage((String)"noMethod01") + "</p>");
        } else {
            this.invokeEndpointFromGet(msgContext, response, method, args.toString());
        }
    }

    protected void processWsdlRequest(MessageContext msgContext, WriterMessageAdapter response) throws AxisFault {
        AxisServer engine = this.getAxis();
        try {
            engine.generateWSDL(msgContext);
            Document doc = (Document)msgContext.getProperty("WSDL");
            if (doc != null) {
                response.setProperty("Content-Type", (Object)"text/xml");
                XMLUtils.DocumentToWriter((Document)doc, (Writer)response.getWriter());
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"processWsdlRequest: failed to create WSDL");
                }
                this.reportNoWSDL(response, "noWSDL02", null);
            }
        }
        catch (AxisFault axisFault) {
            if (axisFault.getFaultCode().equals(Constants.QNAME_NO_SERVICE_FAULT_CODE)) {
                this.processAxisFault(axisFault);
                response.setProperty("http.status", (Object)"404");
                this.reportNoWSDL(response, "noWSDL01", axisFault);
            }
            throw axisFault;
        }
    }

    protected void invokeEndpointFromGet(MessageContext msgContext, WriterMessageAdapter response, String method, String args) throws AxisFault {
        String body = "<" + method + ">" + args + "</" + method + ">";
        String msgtxt = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Body>" + body + "</SOAP-ENV:Body>" + "</SOAP-ENV:Envelope>";
        Message responseMsg = null;
        try {
            ByteArrayInputStream istream = new ByteArrayInputStream(msgtxt.getBytes("ISO-8859-1"));
            AxisServer engine = this.getAxis();
            Message msg = new Message((Object)istream, false);
            msgContext.setRequestMessage(msg);
            AxisServiceProxy.setProperties(RequestContext.getEvent().getEndpoint().getProperties());
            engine.invoke(msgContext);
            responseMsg = msgContext.getResponseMessage();
            response.setProperty("Cache-Control", (Object)"no-cache");
            response.setProperty("Pragma", (Object)"no-cache");
            if (responseMsg == null) {
                throw new Exception(Messages.getMessage((String)"noResponse01"));
            }
        }
        catch (AxisFault fault) {
            this.processAxisFault(fault);
            this.configureResponseFromAxisFault(response, fault);
            responseMsg = new Message((Object)fault);
        }
        catch (Exception e) {
            response.setProperty("http.status", (Object)"500");
            responseMsg = this.convertExceptionToAxisFault(e, responseMsg);
        }
        response.setProperty("Content-Type", (Object)"text/xml");
        response.write(responseMsg.getSOAPPartAsString());
    }

    protected void reportServiceInfo(WriterMessageAdapter response, SOAPService service, String serviceName) {
        response.setProperty("Content-Type", (Object)"text/html");
        response.write("<h1>" + service.getName() + "</h1>");
        response.write("<p>" + Messages.getMessage((String)"axisService00") + "</p>");
        response.write("<i>" + Messages.getMessage((String)"perhaps00") + "</i>");
    }

    protected void processListRequest(WriterMessageAdapter response) throws AxisFault {
        AxisServer engine = this.getAxis();
        response.setProperty("Content-Type", (Object)"text/html");
        if (this.enableList) {
            Document doc = Admin.listConfig((AxisEngine)engine);
            if (doc != null) {
                XMLUtils.DocumentToWriter((Document)doc, (Writer)response.getWriter());
            } else {
                response.setProperty("http.status", (Object)"404");
                response.write("<h2>" + Messages.getMessage((String)"error00") + "</h2>");
                response.write("<p>" + Messages.getMessage((String)"noDeploy00") + "</p>");
            }
        } else {
            response.setProperty("http.status", (Object)"403");
            response.write("<h2>" + Messages.getMessage((String)"error00") + "</h2>");
            response.write("<p><i>?list</i> " + Messages.getMessage((String)"disabled00") + "</p>");
        }
    }

    private void reportNoWSDL(WriterMessageAdapter response, String moreDetailCode, AxisFault axisFault) {
        response.setProperty("http.status", (Object)"404");
        response.setProperty("Content-Type", (Object)"text/html");
        response.write("<h2>" + Messages.getMessage((String)"error00") + "</h2>");
        response.write("<p>" + Messages.getMessage((String)"noWSDL00") + "</p>");
        if (moreDetailCode != null) {
            response.write("<p>" + Messages.getMessage((String)moreDetailCode) + "</p>");
        }
    }

    protected void reportAvailableServices(MuleEventContext context, WriterMessageAdapter response) throws ConfigurationException, AxisFault {
        AxisServer engine = this.getAxis();
        response.setProperty("Content-Type", (Object)"text/html");
        response.write("<h2>And now... Some Services</h2>");
        String version = MuleManifest.getProductVersion();
        if (version == null) {
            version = "Version Not Set";
        }
        response.write("<h5>(Mule - " + version + ")</h5>");
        try {
            response.write("<table width=\"400\"><tr><th>Mule Component Services</th><th>Axis Services</th></tr><tr><td width=\"200\" valign=\"top\">");
            Iterator i = engine.getConfig().getDeployedServices();
            this.listServices(i, response);
            response.write("</td><td width=\"200\" valign=\"top\">");
            i = ((MuleConfigProvider)engine.getConfig()).getAxisDeployedServices();
            this.listServices(i, response);
            response.write("</td></tr></table>");
        }
        catch (ConfigurationException configException) {
            if (configException.getContainedException() instanceof AxisFault) {
                throw (AxisFault)((Object)configException.getContainedException());
            }
            throw configException;
        }
    }

    private void listServices(Iterator i, WriterMessageAdapter response) {
        response.write("<ul>");
        while (i.hasNext()) {
            ArrayList operations;
            ServiceDesc sd = (ServiceDesc)i.next();
            StringBuffer sb = new StringBuffer(512);
            sb.append("<li>");
            String name = sd.getName();
            sb.append(name);
            sb.append(" <a href=\"");
            if (sd.getEndpointURL() != null) {
                sb.append(sd.getEndpointURL());
                if (!sd.getEndpointURL().endsWith("/")) {
                    sb.append("/");
                }
            }
            sb.append(name);
            sb.append("?wsdl\"><i>(wsdl)</i></a></li>");
            response.write(sb.toString());
            if (sd.getDocumentation() != null) {
                response.write("<ul><h6>" + sd.getDocumentation() + "</h6></ul>");
            }
            if ((operations = sd.getOperations()).isEmpty()) continue;
            response.write("<ul>");
            for (OperationDesc desc : operations) {
                response.write("<li>" + desc.getName());
            }
            response.write("</ul>");
        }
        response.write("</ul>");
    }

    protected void reportCantGetAxisService(MuleEventContext context, WriterMessageAdapter response) {
        response.setProperty("http.status", (Object)"404");
        response.setProperty("Content-Type", (Object)"text/html");
        response.write("<h2>" + Messages.getMessage((String)"error00") + "</h2>");
        response.write("<p>" + Messages.getMessage((String)"noService06") + "</p>");
    }

    private void configureResponseFromAxisFault(WriterMessageAdapter response, AxisFault fault) {
        int status = this.getHttpResponseStatus(fault);
        if (status == 401) {
            response.setProperty("WWW-Authenticate", (Object)"Basic realm=\"AXIS\"");
        }
        response.setProperty("http.status", (Object)String.valueOf(status));
    }

    private Message convertExceptionToAxisFault(Exception exception, Message responseMsg) {
        logger.error((Object)exception.getMessage(), (Throwable)exception);
        if (responseMsg == null) {
            AxisFault fault = AxisFault.makeFault((Exception)exception);
            this.processAxisFault(fault);
            responseMsg = new Message((Object)fault);
        }
        return responseMsg;
    }

    protected int getHttpResponseStatus(AxisFault af) {
        return af.getFaultCode().getLocalPart().startsWith("Server.Unauth") ? 401 : 500;
    }

    private void sendResponse(String contentType, WriterMessageAdapter response, Message responseMsg) throws Exception {
        if (responseMsg == null) {
            response.setProperty("http.status", (Object)"204");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"NO AXIS MESSAGE TO RETURN!");
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Returned Content-Type:" + contentType));
            }
            response.setProperty("Content-Type", (Object)contentType);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
            responseMsg.writeTo((OutputStream)baos);
            response.write(baos.toString());
        }
    }

    private void populateMessageContext(MessageContext msgContext, MuleEventContext context, EndpointURI endpointUri) throws AxisFault, ConfigurationException {
        MuleMessage msg = context.getMessage();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MessageContext:" + msgContext));
            logger.debug((Object)("HEADER_CONTENT_TYPE:" + msg.getStringProperty("Content-Type", null)));
            logger.debug((Object)("HEADER_CONTENT_LOCATION:" + msg.getStringProperty("Content-Location", null)));
            logger.debug((Object)("Constants.MC_HOME_DIR:" + String.valueOf(this.getHomeDir())));
            logger.debug((Object)("Constants.MC_RELATIVE_PATH:" + endpointUri.getPath()));
            logger.debug((Object)("HTTPConstants.HEADER_AUTHORIZATION:" + msg.getStringProperty("Authorization", null)));
            logger.debug((Object)("Constants.MC_REMOTE_ADDR:" + endpointUri.getHost()));
        }
        msgContext.setTransportName(this.transportName);
        msgContext.setProperty("home.dir", (Object)this.getHomeDir());
        msgContext.setProperty("path", (Object)endpointUri.getPath());
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, (Object)this);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION, (Object)endpointUri.getPath());
        String serviceName = this.getServiceName(context, endpointUri);
        SOAPService service = msgContext.getAxisEngine().getConfig().getService(new QName(serviceName.substring(1)));
        String scheme = endpointUri.getScheme();
        if (!("vm".equalsIgnoreCase(scheme) || "jms".equalsIgnoreCase(scheme) || "servlet".equalsIgnoreCase(scheme) || service.getOption("componentName") == null)) {
            String servicePath = (String)service.getOption("servicePath");
            if (StringUtils.isEmpty((String)endpointUri.getPath())) {
                if (!("/" + endpointUri.getAddress()).startsWith(servicePath + serviceName)) {
                    throw new AxisFault("Failed to find service: /" + endpointUri.getAddress());
                }
            } else if (!endpointUri.getPath().endsWith(servicePath + serviceName)) {
                throw new AxisFault("Failed to find service: " + endpointUri.getPath());
            }
        }
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, (Object)serviceName);
        msgContext.setProperty("serviceName", (Object)serviceName);
        msgContext.setProperty("Authorization", (Object)msg.getStringProperty("Authorization", null));
        msgContext.setProperty("remoteaddr", (Object)endpointUri.getHost());
        ServletEndpointContextImpl sec = new ServletEndpointContextImpl();
        msgContext.setProperty("servletEndpointContext", (Object)sec);
    }

    private String getSoapAction(MuleEventContext context) throws AxisFault {
        String soapAction = context.getMessage().getStringProperty("SOAPAction", null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Header Soap Action:" + soapAction));
        }
        if (StringUtils.isEmpty((String)soapAction)) {
            soapAction = context.getEndpointURI().getAddress();
        }
        return soapAction;
    }

    protected String getServiceName(MuleEventContext context, EndpointURI endpointUri) throws AxisFault {
        int i;
        String serviceName = endpointUri.getPath();
        if (StringUtils.isEmpty((String)serviceName)) {
            serviceName = this.getSoapAction(context);
            i = (serviceName = serviceName.replaceAll("\"", "")).indexOf("/", serviceName.indexOf("//"));
            if (i < -1) {
                serviceName = serviceName.substring(i + 2);
            }
        }
        if ((i = serviceName.lastIndexOf(47)) > -1) {
            serviceName = serviceName.substring(i);
        }
        if ((i = serviceName.lastIndexOf(63)) > -1) {
            serviceName = serviceName.substring(0, i);
        }
        return serviceName;
    }

    public String getTransportName() {
        return this.transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }

    public boolean isEnableList() {
        return this.enableList;
    }

    public void setEnableList(boolean enableList) {
        this.enableList = enableList;
    }

    public String getHomeDir() {
        if (this.homeDir == null) {
            this.homeDir = DEFAULT_AXIS_HOME;
        }
        return this.homeDir;
    }

    public void setHomeDir(String homeDir) {
        this.homeDir = homeDir;
    }

    public AxisServer getAxis() {
        return this.axis;
    }

    public void setAxis(AxisServer axisServer) {
        this.axis = axisServer;
    }
}

