/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisProperties;
import org.apache.axis.Handler;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.mule.api.MuleException;
import org.mule.api.component.Component;
import org.mule.api.component.JavaComponent;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationCallback;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.component.AbstractJavaComponent;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.soap.NamedParameter;
import org.mule.transport.soap.SoapMethod;
import org.mule.transport.soap.axis.AxisConnector;
import org.mule.transport.soap.axis.AxisInitialisationCallback;
import org.mule.transport.soap.axis.AxisServiceProxy;
import org.mule.transport.soap.axis.extensions.MuleMsgProvider;
import org.mule.transport.soap.axis.extensions.MuleRPCProvider;
import org.mule.transport.soap.axis.i18n.AxisMessages;
import org.mule.util.StringUtils;

public class AxisMessageReceiver
extends AbstractMessageReceiver {
    public static final String AXIS_OPTIONS = "axisOptions";
    public static final String BEAN_TYPES = "beanTypes";
    public static final String SERVICE_NAMESPACE = "serviceNamespace";
    protected AxisConnector connector;
    protected SOAPService soapService;

    public AxisMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.connector = (AxisConnector)connector;
        try {
            AxisServiceProxy.setProperties(endpoint.getProperties());
            this.create();
        }
        catch (Exception e) {
            throw new CreateException((Throwable)e, (Object)this);
        }
    }

    protected void create() throws Exception {
        String wsdlFile;
        StringBuffer buf;
        if (!(this.flowConstruct instanceof Service)) {
            throw new IllegalArgumentException("Only the Service flow constuct is supported by the axis transport");
        }
        Service service = (Service)this.flowConstruct;
        AxisProperties.setProperty((String)"axis.doAutoTypes", (String)String.valueOf(this.connector.isDoAutoTypes()));
        String style = (String)this.endpoint.getProperties().get("style");
        String use = (String)this.endpoint.getProperties().get("use");
        String doc = (String)this.endpoint.getProperties().get("documentation");
        EndpointURI uri = this.endpoint.getEndpointURI();
        String serviceName = this.flowConstruct.getName();
        SOAPService existing = this.connector.getAxis().getService(serviceName);
        if (existing != null) {
            this.soapService = existing;
            this.logger.debug((Object)("Using existing service for " + serviceName));
        } else {
            if (style != null && style.equalsIgnoreCase("message")) {
                this.logger.debug((Object)"Creating Message Provider");
                this.soapService = new SOAPService((Handler)new MuleMsgProvider(this.connector));
            } else {
                this.logger.debug((Object)"Creating RPC Provider");
                this.soapService = new SOAPService((Handler)new MuleRPCProvider(this.connector));
            }
            this.soapService.setEngine((AxisEngine)this.connector.getAxis());
        }
        String servicePath = uri.getPath();
        this.soapService.setOption(serviceName, (Object)this);
        this.soapService.setOption("servicePath", (Object)servicePath);
        this.soapService.setOption("componentName", (Object)serviceName);
        this.soapService.setName(serviceName);
        HashMap<String, String> options = (HashMap<String, String>)this.endpoint.getProperties().get(AXIS_OPTIONS);
        if (options == null) {
            options = new HashMap<String, String>(2);
        }
        if (options.get("wsdlServiceElement") == null) {
            options.put("wsdlServiceElement", serviceName);
        }
        for (Map.Entry entry : options.entrySet()) {
            this.soapService.setOption(entry.getKey().toString(), entry.getValue());
            this.logger.debug((Object)("Adding Axis option: " + entry));
        }
        Class[] interfaces = AxisServiceProxy.getInterfacesForComponent(service);
        if (interfaces.length == 0) {
            throw new InitialisationException(AxisMessages.objectMustImplementAnInterface(serviceName), (Initialisable)service);
        }
        String methodNames = "*";
        Map methods = (Map)this.endpoint.getProperties().get("soapMethods");
        if (methods != null) {
            Iterator i = methods.keySet().iterator();
            buf = new StringBuffer(64);
            while (i.hasNext()) {
                String name = (String)i.next();
                Object m = methods.get(name);
                SoapMethod method = null;
                method = m instanceof List ? new SoapMethod(name, (List)m) : new SoapMethod(name, (String)m);
                List namedParameters = method.getNamedParameters();
                ParameterDesc[] parameters = new ParameterDesc[namedParameters.size()];
                for (int j = 0; j < namedParameters.size(); ++j) {
                    NamedParameter parameter = (NamedParameter)namedParameters.get(j);
                    byte mode = 3;
                    if (parameter.getMode().equals(ParameterMode.IN)) {
                        mode = 1;
                    } else if (parameter.getMode().equals(ParameterMode.OUT)) {
                        mode = 2;
                    }
                    parameters[j] = new ParameterDesc(parameter.getName(), mode, parameter.getType());
                }
                this.soapService.getServiceDescription().addOperationDesc(new OperationDesc(method.getName().getLocalPart(), parameters, method.getReturnType()));
                buf.append(method.getName().getLocalPart() + ",");
            }
            methodNames = buf.toString();
            methodNames = methodNames.substring(0, methodNames.length() - 1);
        } else {
            String[] methodNamesArray = AxisServiceProxy.getMethodNames(interfaces);
            buf = new StringBuffer(64);
            for (int i = 0; i < methodNamesArray.length; ++i) {
                buf.append(methodNamesArray[i]).append(",");
            }
            methodNames = buf.toString();
            methodNames = methodNames.substring(0, methodNames.length() - 1);
        }
        String className = interfaces[0].getName();
        String namespace = (String)this.endpoint.getProperties().get(SERVICE_NAMESPACE);
        if (namespace == null) {
            namespace = Namespaces.makeNamespace((String)className);
        }
        if ((wsdlFile = (String)this.endpoint.getProperties().get("wsdlFile")) != null) {
            this.soapService.getServiceDescription().setWSDLFile(wsdlFile);
        }
        this.setOptionIfNotset(this.soapService, "wsdlServicePort", serviceName);
        this.setOptionIfNotset(this.soapService, "className", className);
        this.setOptionIfNotset(this.soapService, "scope", "Request");
        if (StringUtils.isNotBlank((String)namespace)) {
            this.setOptionIfNotset(this.soapService, "wsdlTargetNamespace", namespace);
        }
        if (methodNames == null) {
            this.setOptionIfNotset(this.soapService, "allowedMethods", "*");
        } else {
            this.setOptionIfNotset(this.soapService, "allowedMethods", methodNames);
        }
        if (style != null) {
            Style s = Style.getStyle((String)style);
            if (s == null) {
                throw new CreateException(CoreMessages.valueIsInvalidFor((String)style, (String)"style"), (Object)this);
            }
            this.soapService.setStyle(s);
        }
        if (use != null) {
            Use u = Use.getUse((String)use);
            if (u == null) {
                throw new CreateException(CoreMessages.valueIsInvalidFor((String)use, (String)"use"), (Object)this);
            }
            this.soapService.setUse(u);
        }
        this.soapService.getServiceDescription().setDocumentation(doc);
        this.soapService.setName(serviceName);
        Component component = service.getComponent();
        if (component instanceof JavaComponent) {
            ((AbstractJavaComponent)component).getObjectFactory().addObjectInitialisationCallback((InitialisationCallback)new AxisInitialisationCallback(this.soapService));
        }
        if (uri.getScheme().equalsIgnoreCase("servlet")) {
            this.connector.addServletService(this.soapService);
            String endpointUrl = uri.getAddress() + "/" + serviceName;
            endpointUrl = endpointUrl.replaceFirst("servlet:", "http:");
            this.soapService.getServiceDescription().setEndpointURL(endpointUrl);
        } else {
            this.soapService.getServiceDescription().setEndpointURL(uri.getAddress() + "/" + serviceName);
        }
        if (StringUtils.isNotBlank((String)namespace)) {
            this.soapService.getServiceDescription().setDefaultNamespace(namespace);
        }
        this.soapService.init();
        this.soapService.stop();
    }

    protected void doConnect() throws Exception {
        this.connector.getServerProvider().deployService(this.soapService.getName(), this.soapService);
        this.connector.registerReceiverWithMuleService((MessageReceiver)this, this.endpoint.getEndpointURI());
    }

    protected void doDisconnect() throws Exception {
        try {
            this.doStop();
        }
        catch (MuleException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.connector.unregisterReceiverWithMuleService((MessageReceiver)this, this.endpoint.getEndpointURI());
    }

    protected void doStart() throws MuleException {
        if (this.soapService != null) {
            this.soapService.start();
        }
    }

    protected void doStop() throws MuleException {
        if (this.soapService != null) {
            this.soapService.stop();
        }
    }

    protected void doDispose() {
    }

    protected void setOptionIfNotset(SOAPService service, String option, Object value) {
        Object val = service.getOption(option);
        if (val == null) {
            service.setOption(option, value);
        }
    }

    public SOAPService getSoapService() {
        return this.soapService;
    }
}

