/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import java.util.Iterator;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.module.cxf.MuleSoapHeaders;
import org.mule.transport.AbstractMuleMessageFactory;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisMuleMessageFactory
extends AbstractMuleMessageFactory {
    private static Log log = LogFactory.getLog(AxisMuleMessageFactory.class);

    public AxisMuleMessageFactory(MuleContext context) {
        super(context);
    }

    protected Class<?>[] getSupportedTransportMessageTypes() {
        return new Class[]{Object.class};
    }

    protected Object extractPayload(Object transportMessage, String encoding) throws Exception {
        return transportMessage;
    }

    protected void addProperties(DefaultMuleMessage message, Object transportMessage) throws Exception {
        MessageContext ctx = MessageContext.getCurrentContext();
        if (ctx != null) {
            MuleSoapHeaders header = new MuleSoapHeaders(ctx.getMessage().getSOAPPart().getEnvelope().getHeader());
            if (StringUtils.isNotBlank((String)header.getReplyTo())) {
                message.setReplyTo((Object)header.getReplyTo());
            }
            if (StringUtils.isNotBlank((String)header.getCorrelationGroup())) {
                message.setCorrelationGroupSize(Integer.parseInt(header.getCorrelationGroup()));
            }
            if (StringUtils.isNotBlank((String)header.getCorrelationSequence())) {
                message.setCorrelationSequence(Integer.parseInt(header.getCorrelationSequence()));
            }
            if (StringUtils.isNotBlank((String)header.getCorrelationId())) {
                message.setCorrelationId(header.getCorrelationId());
            }
        }
    }

    protected void addAttachments(DefaultMuleMessage message, Object transportMessage) throws Exception {
        MessageContext ctx = MessageContext.getCurrentContext();
        if (ctx == null) {
            return;
        }
        try {
            SOAPMessage soapMessage = ctx.getMessage();
            int x = 1;
            Iterator i = soapMessage.getAttachments();
            while (i.hasNext()) {
                String name = String.valueOf(x);
                AttachmentPart attachmentPart = (AttachmentPart)i.next();
                message.addAttachment(name, attachmentPart.getActivationDataHandler());
                ++x;
            }
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to read attachments", (Throwable)e);
        }
    }
}

