/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis.extensions;

import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.module.cxf.MuleSoapHeaders;

public class MuleSoapHeadersHandler
extends BasicHandler {
    private static final long serialVersionUID = 1813393257662701953L;
    protected static final Log logger = LogFactory.getLog(MuleSoapHeadersHandler.class);

    public void invoke(MessageContext msgContext) throws AxisFault {
        boolean setMustUnderstand = msgContext.isPropertyTrue("MULE_HEADER_MUST_UNDERSTAND");
        try {
            if (msgContext.isClient()) {
                if (!msgContext.getPastPivot()) {
                    this.processClientRequest(msgContext, setMustUnderstand);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("After Client Request, Message is:\n" + msgContext.getRequestMessage().getSOAPPartAsString()));
                    }
                } else {
                    this.processClientResponse(msgContext);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("After Client Response, Message is:\n" + msgContext.getRequestMessage().getSOAPPartAsString()));
                    }
                }
            } else if (!msgContext.getPastPivot()) {
                this.processServerRequest(msgContext);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("After Server Request, Message is:\n" + msgContext.getRequestMessage().getSOAPPartAsString()));
                }
            } else {
                this.processServerResponse(msgContext, setMustUnderstand);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("After Server Response, Message is:\n" + msgContext.getRequestMessage().getSOAPPartAsString()));
                }
            }
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void processClientRequest(MessageContext msgContext, boolean setMustUnderstand) throws Exception {
        SOAPMessage msg = msgContext.getMessage();
        if (msg == null) {
            return;
        }
        MuleEvent event = (MuleEvent)msgContext.getProperty("MULE_EVENT");
        if (event == null) {
            return;
        }
        MessageContext messageContext = msgContext;
        synchronized (messageContext) {
            MuleSoapHeaders headers = new MuleSoapHeaders(event);
            headers.addHeaders(msgContext.getMessage().getSOAPPart().getEnvelope());
        }
    }

    protected void processClientResponse(MessageContext msgContext) throws Exception {
        SOAPMessage msg = msgContext.getMessage();
        if (msg == null) {
            return;
        }
        SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
        MuleSoapHeaders headers = new MuleSoapHeaders(env.getHeader());
        if (headers.getCorrelationId() != null) {
            msgContext.setProperty("MULE_CORRELATION_ID", (Object)headers.getCorrelationId());
        }
        if (headers.getCorrelationGroup() != null) {
            msgContext.setProperty("MULE_CORRELATION_GROUP_SIZE", (Object)headers.getCorrelationGroup());
        }
        if (headers.getCorrelationSequence() != null) {
            msgContext.setProperty("MULE_CORRELATION_SEQUENCE", (Object)headers.getCorrelationSequence());
        }
        if (headers.getReplyTo() != null) {
            msgContext.setProperty("MULE_REPLYTO", (Object)headers.getReplyTo());
        }
    }

    protected void processServerRequest(MessageContext msgContext) throws Exception {
        SOAPMessage msg = msgContext.getMessage();
        if (msg == null) {
            return;
        }
        MuleSoapHeaders headers = new MuleSoapHeaders(msg.getSOAPPart().getEnvelope().getHeader());
        msgContext.setProperty("MULE_REQUEST_HEADERS", (Object)headers);
    }

    protected void processServerResponse(MessageContext msgContext, boolean setMustUnderstand) throws Exception {
        SOAPMessage msg = msgContext.getMessage();
        if (msg == null) {
            return;
        }
        MuleSoapHeaders headers = (MuleSoapHeaders)msgContext.getProperty("MULE_REQUEST_HEADERS");
        if (headers == null) {
            return;
        }
        headers.addHeaders(msgContext.getMessage().getSOAPPart().getEnvelope());
    }
}

