/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis.config;

import java.util.HashMap;
import java.util.Map;
import org.mule.config.spring.handlers.AbstractMuleNamespaceHandler;
import org.mule.config.spring.parsers.MuleDefinitionParser;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.config.spring.parsers.collection.ChildListEntryDefinitionParser;
import org.mule.config.spring.parsers.delegate.ParentContextDefinitionParser;
import org.mule.config.spring.parsers.processors.AttributeConcatenation;
import org.mule.config.spring.parsers.specific.ComponentDefinitionParser;
import org.mule.config.spring.parsers.specific.properties.ElementInNestedMapDefinitionParser;
import org.mule.config.spring.parsers.specific.properties.ListPropertyDefinitionParser;
import org.mule.config.spring.parsers.specific.properties.NestedListDefinitionParser;
import org.mule.config.spring.parsers.specific.properties.NestedMapWithAttributesDefinitionParser;
import org.mule.config.spring.parsers.specific.properties.SimplePropertyDefinitionParser;
import org.mule.transport.soap.axis.AxisConnector;
import org.mule.transport.soap.axis.component.WebServiceWrapperComponent;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.w3c.dom.Element;

public class AxisNamespaceHandler
extends AbstractMuleNamespaceHandler {
    public static final String PROPERTIES = "properties";
    public static final Map<String, String> USE_MAP = new HashMap<String, String>();
    public static final Map<String, String> STYLE_MAP = new HashMap<String, String>();

    public void init() {
        this.registerMetaTransportEndpoints("axis").addMapping("use", USE_MAP).addMapping("style", STYLE_MAP);
        this.registerConnectorDefinitionParser(AxisConnector.class);
        this.registerBeanDefinitionParser("supported-scheme", (BeanDefinitionParser)new ChildListEntryDefinitionParser("supportedSchemes", "value"));
        this.registerBeanDefinitionParser("soap-method", (BeanDefinitionParser)new ElementInNestedMapDefinitionParser(PROPERTIES, "soapMethods", "method"));
        this.registerBeanDefinitionParser("soap-parameter", (BeanDefinitionParser)new SoapParameterDefinitionParser());
        this.registerBeanDefinitionParser("soap-return", (BeanDefinitionParser)new SoapReturnDefinitionParser());
        this.registerMuleBeanDefinitionParser("soap-service", (MuleDefinitionParser)new NestedListDefinitionParser(PROPERTIES, "serviceInterfaces", "interface"));
        this.registerMuleBeanDefinitionParser("options", (MuleDefinitionParser)new NestedMapWithAttributesDefinitionParser(PROPERTIES, "axisOptions"));
        this.registerMuleBeanDefinitionParser("option", (MuleDefinitionParser)new SimplePropertyDefinitionParser());
        this.registerMuleBeanDefinitionParser("bean-type", (MuleDefinitionParser)new ParentContextDefinitionParser("connector", (MuleDefinitionParser)new ChildListEntryDefinitionParser("beanTypes", "interface")).otherwise((MuleDefinitionParser)new NestedListDefinitionParser(PROPERTIES, "beanTypes", "interface")));
        this.registerBeanDefinitionParser("wrapper-component", (BeanDefinitionParser)new ComponentDefinitionParser(WebServiceWrapperComponent.class));
    }

    static {
        USE_MAP.put("LITERAL", "literal");
        USE_MAP.put("ENCODED", "encoded");
        STYLE_MAP.put("DOCUMENT", "document");
        STYLE_MAP.put("MESSAGE", "message");
        STYLE_MAP.put("RPC", "rpc");
        STYLE_MAP.put("WRAPPED", "wrapped");
    }

    private static class SoapReturnDefinitionParser
    extends ListPropertyDefinitionParser {
        public SoapReturnDefinitionParser() {
            super("value");
            this.registerPreProcessor(new PreProcessor(){

                public void preProcess(PropertyConfiguration config, Element element) {
                    element.setAttribute("value", "return;" + element.getAttribute("type"));
                }
            });
        }
    }

    private static class SoapParameterDefinitionParser
    extends ListPropertyDefinitionParser {
        public static final String PARAMETER = "parameter";

        public SoapParameterDefinitionParser() {
            super(PARAMETER);
            this.registerPreProcessor((PreProcessor)new AttributeConcatenation(PARAMETER, ";", new String[]{PARAMETER, "type", "mode"}));
        }
    }
}

