/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import org.apache.axis.AxisFault;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.transport.DispatchException;
import org.mule.tck.junit4.FunctionalTestCase;

public class AxisConnectorJmsEndpointFormatTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "axis-jms-endpoint-format-config.xml";
    }

    @Test
    public void testAxisOverJmsWithQueueNameSameAsComponentName() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("componentName", (MuleMessage)new DefaultMuleMessage((Object)"test1", muleContext));
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertEquals((Object)"test1", (Object)result.getPayloadAsString());
    }

    @Test
    public void testAxisOverJmsWithQueueNameDifferentFromComponentName() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("soapActionDefined", (MuleMessage)new DefaultMuleMessage((Object)"test2", muleContext));
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertEquals((Object)"test2", (Object)result.getPayloadAsString());
    }

    @Test
    public void testAxisOverJmsWithoutSettingMethodOnEndpoint() throws Exception {
        try {
            LocalMuleClient client = muleContext.getClient();
            client.send("noMethodDefined", (MuleMessage)new DefaultMuleMessage((Object)"test3", muleContext));
            Assert.fail((String)"Exception expected");
        }
        catch (DispatchException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot invoke WS call without an Operation."));
        }
    }

    @Test
    public void testAxisOverJmsWithoutSettingSoapAction() throws Exception {
        try {
            LocalMuleClient client = muleContext.getClient();
            client.send("noSoapActionDefined", (MuleMessage)new DefaultMuleMessage((Object)"test4", muleContext));
            Assert.fail((String)"Exception expected");
        }
        catch (DispatchException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof AxisFault));
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("The AXIS engine could not find a target service to invoke!"));
        }
    }
}

