/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis.functional;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class AxisSoapHeadersTestCase
extends FunctionalTestCase {
    private static final String EXPECTED_RESPONSE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><echoResponse soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><echoReturn xsi:type=\"xsd:string\">Test Message</echoReturn></echoResponse></soapenv:Body></soapenv:Envelope>";
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    protected String getConfigFile() {
        return "axis-soapheader-test.xml";
    }

    @Test
    public void testSoapRequest() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("http.method", "POST");
        DefaultMuleMessage soapRequest = null;
        soapRequest = new DefaultMuleMessage((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:mule=\"http://www.muleumo.org/providers/soap/1.0\"><soapenv:Header><Action>storeModuleInformation</Action><mule:header><mule:MULE_REPLYTO>http://localhost:62182/reply</mule:MULE_REPLYTO></mule:header></soapenv:Header><soapenv:Body><echo soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><value0 xsi:type=\"soapenc:string\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">Test Message</value0></echo></soapenv:Body></soapenv:Envelope>", muleContext);
        MuleMessage reply = client.send("http://localhost:" + this.dynamicPort1.getNumber() + "/services/component", (Object)soapRequest, properties);
        Thread.sleep(2000L);
        Assert.assertEquals((Object)EXPECTED_RESPONSE, (Object)reply.getPayloadAsString());
    }
}

