/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis.functional;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class WebServiceWrapperWithAxisTestCase
extends FunctionalTestCase {
    private String testString = "test";
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    protected String getConfigFile() {
        return "mule-ws-wrapper-config.xml";
    }

    @Test
    public void testWsCall() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://testin", (MuleMessage)new DefaultMuleMessage((Object)this.testString, muleContext));
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertEquals((String)"Payload", (Object)("Received: " + this.testString), (Object)result.getPayloadAsString());
    }

    @Test
    public void testWsCallWithUrlFromMessage() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("ws.service.url", "http://localhost:" + this.dynamicPort1.getNumber() + "/services/TestUMO?method=receive");
        MuleMessage result = client.send("vm://testin2", (Object)this.testString, props);
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertEquals((String)"Payload", (Object)("Received: " + this.testString), (Object)result.getPayloadAsString());
    }

    @Test
    public void testWsCallWithComplexParameters() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://queue.in", (Object)new Object[]{new Long(3L), new Long(3L)}, null);
        MuleMessage result = client.request("vm://queue.out", 5000L);
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertTrue((boolean)(result.getPayload() instanceof Long));
        Assert.assertEquals((String)"Payload", (long)6L, (long)((Long)result.getPayload()).intValue());
    }
}

