/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.soap.axis.NamedParameter;
import org.mule.transport.soap.axis.SoapMethod;

public class AxisNamedParametersTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "axis-named-param-mule-config.xml";
    }

    @Test
    public void testNamedParameters() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://mycomponent1", (Object)"Hello Named", null);
        Assert.assertEquals((Object)"Hello Named", (Object)result.getPayload());
    }

    @Test
    public void testNamedParametersViaClient() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, SoapMethod> props = new HashMap<String, SoapMethod>();
        SoapMethod soapMethod = new SoapMethod(new QName("echo"), NamedParameter.XSD_STRING);
        soapMethod.addNamedParameter(new QName("value"), NamedParameter.XSD_STRING, ParameterMode.IN);
        props.put("MULE_SOAP_METHOD", soapMethod);
        MuleMessage result = client.send("axis:http://localhost:" + this.dynamicPort.getNumber() + "/mule/mycomponent2?method=echo", (Object)"Hello Named", props);
        Assert.assertEquals((Object)"Hello Named", (Object)result.getPayload());
    }
}

