/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.soap.axis.AxisConnector;
import org.mule.transport.soap.axis.mock.MockAxisServer;
import org.mule.transport.soap.axis.mock.MockProvider;

public class AxisNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "axis-namespace-config.xml";
    }

    @Test
    public void testConfig() {
        AxisConnector connector = (AxisConnector)muleContext.getRegistry().lookupConnector("axisConnector");
        Assert.assertNotNull((Object)connector);
        Assert.assertEquals((Object)"test-axis-config.wsdd", (Object)connector.getServerConfig());
        Assert.assertEquals((Object)"test-axis-config.wsdd", (Object)connector.getClientConfig());
        Assert.assertFalse((boolean)connector.isTreatMapAsNamedParams());
        Assert.assertFalse((boolean)connector.isDoAutoTypes());
        Assert.assertEquals((long)2L, (long)connector.getBeanTypes().size());
        Assert.assertTrue((boolean)connector.getBeanTypes().contains("org.mule.tck.testmodels.fruit.Apple"));
        Assert.assertTrue((boolean)connector.getBeanTypes().contains("org.mule.tck.testmodels.fruit.Banana"));
        Assert.assertEquals((long)1L, (long)connector.getSupportedSchemes().size());
        Assert.assertEquals((Object)"http", connector.getSupportedSchemes().get(0));
    }

    @Test
    public void testInjectedObjects() {
        AxisConnector connector = (AxisConnector)muleContext.getRegistry().lookupConnector("axisConnector2");
        Assert.assertNotNull((Object)connector);
        Assert.assertEquals(MockAxisServer.class, connector.getAxis().getClass());
        Assert.assertEquals(MockProvider.class, connector.getClientProvider().getClass());
    }

    @Test
    public void testEndpointProperties() throws Exception {
        OutboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointBuilder("endpoint").buildOutboundEndpoint();
        Map props = endpoint.getProperties();
        Assert.assertEquals((Object)"#[methodNamespace]#[method]", (Object)this.assertKey(props, "soapAction", String.class));
        Assert.assertEquals((Object)"direct", (Object)this.assertKey(props, "SOAPAction", String.class));
        Assert.assertEquals((Object)"clientConfig", (Object)this.assertKey(props, "clientConfig", String.class));
        Assert.assertEquals((Object)"encoded", (Object)this.assertKey(props, "use", String.class));
        Assert.assertEquals((Object)"document", (Object)this.assertKey(props, "style", String.class));
        Assert.assertEquals((Object)"value1", (Object)this.assertKey(props, "key1", String.class));
        Assert.assertEquals((Object)"value2", (Object)this.assertKey(props, "key2", String.class));
        Map options = (Map)this.assertKey(props, "axisOptions", Map.class);
        Assert.assertEquals((long)10L, (long)options.size());
        Assert.assertEquals((Object)"value1", (Object)this.assertKey(options, "key1", String.class));
        Assert.assertEquals((Object)"value2", (Object)this.assertKey(options, "key2", String.class));
        Assert.assertEquals((Object)"Application", (Object)this.assertKey(options, "scope", String.class));
        Assert.assertEquals((Object)"echo,getdate", (Object)this.assertKey(options, "allowedMethods", String.class));
        Assert.assertEquals((Object)"wsdlPortType", (Object)this.assertKey(options, "wsdlPortType", String.class));
        Assert.assertEquals((Object)"wsdlServiceElement", (Object)this.assertKey(options, "wsdlServiceElement", String.class));
        Assert.assertEquals((Object)"wsdlTargetNamespace", (Object)this.assertKey(options, "wsdlTargetNamespace", String.class));
        Assert.assertEquals((Object)"wsdlInputSchema", (Object)this.assertKey(options, "wsdlInputSchema", String.class));
        Assert.assertEquals((Object)"wsdlSoapActionMode", (Object)this.assertKey(options, "wsdlSoapActionMode", String.class));
        Assert.assertEquals((Object)"extraClasses", (Object)this.assertKey(options, "extraClasses", String.class));
        Map methods = (Map)this.assertKey(props, "soapMethods", Map.class);
        List method1 = (List)this.assertKey(methods, "method1", List.class);
        Assert.assertEquals((long)3L, (long)method1.size());
        Assert.assertEquals((Object)"symbol;string;IN", method1.get(0));
        Assert.assertEquals((Object)"GetQuoteResult;string;OUT", method1.get(1));
        Assert.assertEquals((Object)"return;string", method1.get(2));
        List method2 = (List)this.assertKey(methods, "method2", List.class);
        Assert.assertEquals((long)2L, (long)method2.size());
        Assert.assertEquals((Object)"param;string;IN", method2.get(0));
        Assert.assertEquals((Object)"addedFromSpring;string;in", method2.get(1));
        List interfaces = (List)this.assertKey(props, "serviceInterfaces", List.class);
        Assert.assertEquals((long)2L, (long)interfaces.size());
        Assert.assertEquals((Object)"class1", interfaces.get(0));
        Assert.assertEquals((Object)"class2", interfaces.get(1));
    }

    protected Object assertKey(Map props, String name, Class clazz) {
        Assert.assertNotNull((Object)props);
        Assert.assertTrue((String)(name + " not in properties"), (boolean)props.containsKey(name));
        Object value = props.get(name);
        Assert.assertNotNull((String)(name + " value null"), value);
        Assert.assertTrue((String)(value.getClass() + " not subclass of " + clazz), (boolean)clazz.isAssignableFrom(value.getClass()));
        return value;
    }
}

