/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis.issues;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.Connector;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.soap.axis.AxisConnector;

public class EndpointRetrievalMule2021TestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public EndpointRetrievalMule2021TestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "endpoint-retrieval-mule-2021-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "endpoint-retrieval-mule-2021-test-flow.xml"});
    }

    @Test
    public void testLookupEndpoint() throws MuleException {
        Object endpoint1 = muleContext.getRegistry().lookupObject("Endpoint");
        Assert.assertTrue((boolean)(endpoint1 instanceof EndpointBuilder));
        Assert.assertFalse((boolean)(endpoint1 instanceof ImmutableEndpoint));
        EndpointBuilder endpointBuiler = muleContext.getRegistry().lookupEndpointBuilder("Endpoint");
        Assert.assertNotNull((Object)endpointBuiler);
        ImmutableEndpoint endpoint2 = (ImmutableEndpoint)muleContext.getRegistry().lookupObject("axis:http://localhost:" + this.dynamicPort.getNumber() + "/mule/Service?method=toString");
        Assert.assertNull((Object)endpoint2);
    }

    @Test
    public void testGetOutboundEndpoint() throws MuleException {
        OutboundEndpoint endpoint1 = muleContext.getEndpointFactory().getOutboundEndpoint("Endpoint");
        this.assertEndpointOk((ImmutableEndpoint)endpoint1);
        OutboundEndpoint endpoint2 = muleContext.getEndpointFactory().getOutboundEndpoint("axis:http://localhost:" + this.dynamicPort.getNumber() + "/mule/Service?method=toString");
        this.assertEndpointOk((ImmutableEndpoint)endpoint2);
    }

    @Test
    public void testGetInboundEndpoint() throws MuleException {
        InboundEndpoint endpoint1 = muleContext.getEndpointFactory().getInboundEndpoint("Endpoint");
        this.assertEndpointOk((ImmutableEndpoint)endpoint1);
        InboundEndpoint endpoint2 = muleContext.getEndpointFactory().getInboundEndpoint("axis:http://localhost:" + this.dynamicPort.getNumber() + "/mule/Service?method=toString");
        this.assertEndpointOk((ImmutableEndpoint)endpoint2);
    }

    @Test
    public void testGetResponseEndpoint() throws MuleException {
        InboundEndpoint endpoint1 = muleContext.getEndpointFactory().getInboundEndpoint("Endpoint");
        this.assertEndpointOk((ImmutableEndpoint)endpoint1);
        InboundEndpoint endpoint2 = muleContext.getEndpointFactory().getInboundEndpoint("axis:http://localhost:" + this.dynamicPort.getNumber() + "/mule/Service?method=toString");
        this.assertEndpointOk((ImmutableEndpoint)endpoint2);
    }

    private void assertEndpointOk(ImmutableEndpoint endpoint) {
        Assert.assertNotNull((String)"Endpoint is null", (Object)endpoint);
        Connector connector = endpoint.getConnector();
        Assert.assertTrue((String)"Connector not AXIS", (boolean)(connector instanceof AxisConnector));
    }
}

