/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis.style;

import java.net.URL;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.soap.axis.NamedParameter;
import org.mule.transport.soap.axis.SoapMethod;
import org.mule.util.StringUtils;

public class AxisMessageStyleServiceTestCase
extends FunctionalTestCase {
    private static String expectedResult = "TEST RESPONSE";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public String getConfigFile() {
        return "style/axis-mule-message-config.xml";
    }

    protected String getServiceEndpoint() {
        return "http://localhost:" + this.dynamicPort.getNumber() + "/ServiceEntryPoint";
    }

    @Test
    public void testDocumentWithNamespace() throws Exception {
        this.doSoapRequest(new QName("http://muleumo.org", "document"), "axis:" + this.getServiceEndpoint(), false, false, false);
    }

    @Test
    public void testDocumentWithQName() throws Exception {
        this.doSoapRequest(new QName("http://muleumo.org", "document"), "axis:" + this.getServiceEndpoint(), false, false, true);
    }

    @Test
    public void testDocumentWithAxisApi() throws Exception {
        this.doSoapRequest(new QName("http://muleumo.org", "document"), this.getServiceEndpoint(), true, false, false);
    }

    @Test
    public void testDocumentWithSoapMethod() throws Exception {
        this.doSoapRequest(new QName("http://muleumo.org", "document"), "axis:" + this.getServiceEndpoint(), false, true, false);
    }

    @Test
    public void testElementArrayWithSoapMethod() throws Exception {
        this.doSoapRequest(new QName("http://muleumo.org", "elementArray"), "axis:" + this.getServiceEndpoint(), false, true, false);
    }

    @Test
    public void testElementArrayWithNamesapce() throws Exception {
        this.doSoapRequest(new QName("http://muleumo.org", "elementArray"), "axis:" + this.getServiceEndpoint(), false, false, false);
    }

    @Test
    public void testElementArrayWithQName() throws Exception {
        this.doSoapRequest(new QName("http://muleumo.org", "elementArray"), "axis:" + this.getServiceEndpoint(), false, false, true);
    }

    @Test
    public void testElementArrayWithAxisApi() throws Exception {
        this.doSoapRequest(new QName("http://muleumo.org", "elementArray"), this.getServiceEndpoint(), true, false, false);
    }

    @Test
    public void testSoapBodyElementWithSoapMethod() throws Exception {
        this.doSoapRequest(new QName("http://muleumo.org", "soapBodyElement"), "axis:" + this.getServiceEndpoint(), false, true, false);
    }

    @Test
    public void testSoapBodyElementWithNamesapce() throws Exception {
        this.doSoapRequest(new QName("http://muleumo.org", "soapBodyElement"), "axis:" + this.getServiceEndpoint(), false, false, false);
    }

    @Test
    public void testSoapBodyElementWithQName() throws Exception {
        this.doSoapRequest(new QName("http://muleumo.org", "soapBodyElement"), "axis:" + this.getServiceEndpoint(), false, false, true);
    }

    @Test
    public void testSoapBodyElementWithAxisApi() throws Exception {
        this.doSoapRequest(new QName("http://muleumo.org", "soapBodyElement"), this.getServiceEndpoint(), true, false, false);
    }

    @Test
    public void testSoapRequestResponseWithAxisApi() throws Exception {
        this.doSoapRequest(new QName("http://muleumo.org", "soapRequestResponse"), this.getServiceEndpoint(), true, false, false);
    }

    protected void doSoapRequest(QName method, String endpoint, boolean useAxisApi, boolean useSoapMethod, boolean useQNameMethod) throws Exception {
        if (useAxisApi) {
            Service service = new Service();
            Call call = (Call)service.createCall();
            call.setTargetEndpointAddress(new URL(endpoint));
            call.setOperationName(method);
            String ret = (String)call.invoke(new Object[]{expectedResult});
            Assert.assertNotNull((Object)ret);
            Assert.assertEquals((Object)ret, (Object)expectedResult);
        } else {
            LocalMuleClient client = muleContext.getClient();
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (useSoapMethod) {
                SoapMethod soapMethod = new SoapMethod(method);
                soapMethod.addNamedParameter(new QName(method.getNamespaceURI(), method.getLocalPart()), NamedParameter.XSD_STRING, ParameterMode.IN);
                props.put("method", soapMethod);
            } else if (useQNameMethod) {
                props.put("method", method);
            } else {
                endpoint = endpoint + "?method=" + method.getLocalPart();
                if (StringUtils.isNotBlank((String)method.getNamespaceURI())) {
                    props.put("methodNamespace", method.getNamespaceURI());
                }
            }
            MuleMessage result = client.send(endpoint, (Object)expectedResult, props);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)expectedResult, (Object)result.getPayloadAsString());
        }
    }
}

