/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.testmodels.services.Person;
import org.mule.transport.NullPayload;

public abstract class AbstractSoapFunctionalTestCase
extends FunctionalTestCase {
    protected abstract String getRequestResponseEndpoint();

    protected abstract String getReceiveEndpoint();

    protected abstract String getReceiveComplexEndpoint();

    protected abstract String getSendReceiveComplexEndpoint1();

    protected abstract String getSendReceiveComplexEndpoint2();

    protected abstract String getReceiveComplexCollectionEndpoint();

    protected abstract String getDispatchAsyncComplexEndpoint1();

    protected abstract String getDispatchAsyncComplexEndpoint2();

    protected abstract String getTestExceptionEndpoint();

    protected abstract String getWsdlEndpoint();

    @Test
    public void testRequestResponse() throws Throwable {
        int i;
        LocalMuleClient client = muleContext.getClient();
        ArrayList<Object> results = new ArrayList<Object>();
        int number = 1;
        HashMap<String, String> props = new HashMap<String, String>();
        for (i = 0; i < number; ++i) {
            props.put("X-Message-Number", String.valueOf(i));
            MuleMessage msg = client.send(this.getRequestResponseEndpoint(), (Object)("Message " + i), props);
            Assert.assertNotNull((Object)msg);
            results.add(msg.getPayload());
        }
        Assert.assertEquals((long)number, (long)results.size());
        for (i = 0; i < number; ++i) {
            Assert.assertEquals((Object)("Message " + i), (Object)results.get(i).toString());
        }
    }

    @Test
    public void testRequest() throws Throwable {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.request(this.getReceiveEndpoint(), 0L);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertTrue((result.getPayload().toString().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReceiveComplex() throws Throwable {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.request(this.getReceiveComplexEndpoint(), 0L);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result.getPayload() instanceof Person));
        Assert.assertEquals((Object)"Fred", (Object)((Person)result.getPayload()).getFirstName());
        Assert.assertEquals((Object)"Flintstone", (Object)((Person)result.getPayload()).getLastName());
        result = client.request(this.getReceiveComplexEndpoint(), 0L);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result.getPayload() instanceof Person));
        Assert.assertEquals((Object)"Fred", (Object)((Person)result.getPayload()).getFirstName());
        Assert.assertEquals((Object)"Flintstone", (Object)((Person)result.getPayload()).getLastName());
    }

    @Test
    public void testSendAndReceiveComplex() throws Throwable {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send(this.getSendReceiveComplexEndpoint1(), (Object)new Person("Dino", "Flintstone"), null);
        Assert.assertEquals((Object)NullPayload.getInstance(), (Object)result.getPayload());
        result = client.request(this.getSendReceiveComplexEndpoint2(), 0L);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result.getPayload() instanceof Person));
        Assert.assertEquals((Object)"Dino", (Object)((Person)result.getPayload()).getFirstName());
        Assert.assertEquals((Object)"Flintstone", (Object)((Person)result.getPayload()).getLastName());
    }

    @Test
    public void testReceiveComplexCollection() throws Throwable {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.request(this.getReceiveComplexCollectionEndpoint(), 0L);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result.getPayload() instanceof Person[]));
        Assert.assertEquals((long)3L, (long)((Person[])result.getPayload()).length);
    }

    @Test
    public void testDispatchAsyncComplex() throws Throwable {
        LocalMuleClient client = muleContext.getClient();
        client.send(this.getDispatchAsyncComplexEndpoint1(), (Object)new Person("Betty", "Rubble"), null);
        MuleMessage result = client.request(this.getDispatchAsyncComplexEndpoint2(), 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)("Did not receive a Person but: " + result.getPayload().getClass()), (boolean)(result.getPayload() instanceof Person));
        Assert.assertEquals((Object)"Betty", (Object)((Person)result.getPayload()).getFirstName());
        Assert.assertEquals((Object)"Rubble", (Object)((Person)result.getPayload()).getLastName());
    }

    @Test
    public void testException() throws Exception {
        try {
            muleContext.getClient().send(this.getTestExceptionEndpoint(), (Object)new Person("Ross", "Mason"), null);
            Assert.fail((String)"A nested Fault should have been raised");
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    @Test
    public void testLocationUrlInWSDL() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("http.method", "GET");
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send(this.getWsdlEndpoint(), null, props);
        Assert.assertNotNull((Object)result);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)result.getPayloadAsString());
        }
        String location = this.getWsdlEndpoint();
        if ((location = location.substring(0, location.length() - 5)).endsWith("/")) {
            location = location.substring(0, location.length() - 1);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)result.getPayloadAsString());
        }
        System.out.println(result.getPayloadAsString());
        if (result.getPayloadAsString().indexOf("location=\"" + location) == -1) {
            Assert.assertTrue((result.getPayloadAsString().indexOf("location='" + location) > -1 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((result.getPayloadAsString().indexOf("location=\"" + location) > -1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)((String)result.getInboundProperty("Content-Type", (Object)"")).startsWith("text/xml"));
    }
}

