/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.endpoint.EndpointAware;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.http.HttpsConnector;

public class AxisConnectorHttpsTestCase
extends FunctionalTestCase {
    static ImmutableEndpoint endpoint;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "axis-https-connector-config.xml";
    }

    @Test
    public void testHttpsConnection() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        InboundEndpoint inboundEndpoint = (InboundEndpoint)muleContext.getRegistry().lookupObject("inTestUMO");
        MuleMessage m = client.send(inboundEndpoint.getAddress() + "?method=echo", (MuleMessage)new DefaultMuleMessage((Object)"hello", muleContext));
        Assert.assertNotNull((Object)m);
        Assert.assertNotNull((Object)endpoint);
        Assert.assertTrue((boolean)(endpoint.getConnector() instanceof HttpsConnector));
        Assert.assertTrue((boolean)endpoint.getConnector().getName().equals("myHttpsConnector"));
    }

    public static class AddConnectorMessageProperty
    implements MessageProcessor,
    EndpointAware {
        private ImmutableEndpoint myEndpoint;

        public MuleEvent process(MuleEvent event) throws MuleException {
            endpoint = this.myEndpoint;
            return event;
        }

        public void setEndpoint(ImmutableEndpoint ep) {
            this.myEndpoint = ep;
        }
    }
}

