/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class AxisConnectorLifecycleTestCase
extends FunctionalTestCase {
    private static String SERVICE_NAME = "mycomponent";
    private static String PROTOCOL_SERVICE_NAME = "_axisServiceconnector.axis.0";
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");
    @Rule
    public DynamicPort dynamicPort3 = new DynamicPort("port3");

    protected String getConfigFile() {
        return "axis-http-mule-config.xml";
    }

    @Test
    public void testStopService() throws MuleException {
        muleContext.getRegistry().lookupService(SERVICE_NAME).stop();
        Assert.assertFalse((boolean)muleContext.getRegistry().lookupService(SERVICE_NAME).isStarted());
        Assert.assertFalse((boolean)muleContext.getRegistry().lookupService(PROTOCOL_SERVICE_NAME).isStarted());
    }

    @Test
    public void testDisposeService() throws MuleException {
        muleContext.getRegistry().lookupService(SERVICE_NAME).dispose();
        Assert.assertFalse((boolean)muleContext.getRegistry().lookupService(SERVICE_NAME).isStarted());
        Assert.assertNull((Object)muleContext.getRegistry().lookupService(PROTOCOL_SERVICE_NAME));
    }

    @Test
    public void testRestartService() throws MuleException {
        muleContext.getRegistry().lookupService(SERVICE_NAME).stop();
        Assert.assertFalse((boolean)muleContext.getRegistry().lookupService(SERVICE_NAME).isStarted());
        Assert.assertFalse((boolean)muleContext.getRegistry().lookupService(PROTOCOL_SERVICE_NAME).isStarted());
        muleContext.getRegistry().lookupService(SERVICE_NAME).start();
        Assert.assertTrue((boolean)muleContext.getRegistry().lookupService(SERVICE_NAME).isStarted());
        Assert.assertTrue((boolean)muleContext.getRegistry().lookupService(PROTOCOL_SERVICE_NAME).isStarted());
    }
}

