/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisEngine;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.transport.AbstractMuleMessageFactoryTestCase;
import org.mule.transport.soap.axis.AxisMuleMessageFactory;
import org.mule.transport.soap.axis.mock.MockAxisEngine;
import org.mule.transport.soap.axis.mock.MockEngineConfiguration;

public class AxisMuleMessageFactoryTestCase
extends AbstractMuleMessageFactoryTestCase {
    private static final String XML_WITH_HEADERS = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">    <soapenv:Header>        <mule:header soapenv:actor=\"http://www.muleumo.org/providers/soap/1.0\" soapenv:mustUnderstand=\"0\" xmlns:mule=\"http://www.muleumo.org/providers/soap/1.0\">            <mule:MULE_REPLYTO>replyTo</mule:MULE_REPLYTO>            <mule:MULE_CORRELATION_ID>004a1cf9-3e7e-44b3-9b7f-778fae4fa0d2</mule:MULE_CORRELATION_ID>            <mule:MULE_CORRELATION_GROUP_SIZE>42</mule:MULE_CORRELATION_GROUP_SIZE>            <mule:MULE_CORRELATION_SEQUENCE>-42</mule:MULE_CORRELATION_SEQUENCE>        </mule:header>    </soapenv:Header>    <soapenv:Body>        <echo soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">            <value0 xsi:type=\"soapenc:string\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">                Hello            </value0>        </echo>    </soapenv:Body></soapenv:Envelope>";

    public AxisMuleMessageFactoryTestCase() {
        this.runUnsuppoprtedTransportMessageTest = false;
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.setupAxisMessageContext();
    }

    protected MuleMessageFactory doCreateMuleMessageFactory() {
        return new AxisMuleMessageFactory();
    }

    protected Object getValidTransportMessage() throws Exception {
        return new Message((Object)XML_WITH_HEADERS);
    }

    @Test
    public void testSoapHeaders() throws Exception {
        MuleMessageFactory factory = this.createMuleMessageFactory();
        Object payload = this.getValidTransportMessage();
        MuleMessage message = factory.create(payload, this.encoding, muleContext);
        Assert.assertEquals((Object)payload, (Object)message.getPayload());
        Assert.assertEquals((Object)"replyTo", (Object)message.getReplyTo());
        Assert.assertEquals((long)42L, (long)message.getCorrelationGroupSize());
        Assert.assertEquals((long)-42L, (long)message.getCorrelationSequence());
        Assert.assertEquals((Object)"004a1cf9-3e7e-44b3-9b7f-778fae4fa0d2", (Object)message.getCorrelationId());
    }

    private void setupAxisMessageContext() {
        MockEngineConfiguration configuration = new MockEngineConfiguration();
        MockAxisEngine engine = new MockAxisEngine(configuration);
        MessageContext messageContext = new MessageContext((AxisEngine)engine);
        MockAxisEngine.setCurrentMessageContext(messageContext);
        Message soapMessage = new Message((Object)XML_WITH_HEADERS);
        messageContext.setMessage((SOAPMessage)soapMessage);
    }
}

