/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import java.util.EventListener;
import java.util.HashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.servlet.MuleReceiverServlet;
import org.mule.transport.soap.axis.UnitTestExceptionStrategy;

public class AxisServletWithSecurityTestCase
extends FunctionalTestCase {
    public static int HTTP_PORT = -1;
    private Server httpServer;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "axis-servlet-security-config.xml";
    }

    protected void doSetUp() throws Exception {
        HTTP_PORT = this.dynamicPort.getNumber();
        this.httpServer = new Server(HTTP_PORT);
        ServletContextHandler c = new ServletContextHandler((HandlerContainer)this.httpServer, "/", 1);
        c.addServlet(new ServletHolder((Servlet)new MuleReceiverServlet()), "/services/*");
        c.addEventListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                sce.getServletContext().setAttribute("mule.context", (Object)muleContext);
            }

            public void contextDestroyed(ServletContextEvent sce) {
            }
        });
        this.httpServer.start();
    }

    protected void doTearDown() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.stop();
            this.httpServer.destroy();
        }
    }

    @Test
    public void testSecurityWithServletsUsingGet() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("http.method", "GET");
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://ross:ross@localhost:" + HTTP_PORT + "/services/mycomponent?method=echo", (Object)"test", props);
        String status = (String)result.getProperty("http.status", PropertyScope.INBOUND);
        Assert.assertEquals((long)401L, (long)new Integer(status).intValue());
        MessagingExceptionHandler exceptionListener = muleContext.getRegistry().lookupService("mycomponent").getExceptionListener();
        Assert.assertTrue((boolean)(exceptionListener instanceof UnitTestExceptionStrategy));
        UnitTestExceptionStrategy utExStrat = (UnitTestExceptionStrategy)exceptionListener;
        Assert.assertEquals((long)1L, (long)utExStrat.getMessagingExceptions().size());
        Assert.assertNotNull((Object)result);
    }
}

