/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.soap.axis.AxisMessageDispatcher;

public class SoapActionTemplateTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testHostInfoReplace() throws Exception {
        OutboundEndpoint ep = muleContext.getEndpointFactory().getOutboundEndpoint("axis:http://mycompany.com:8080/services/myService?method=foo");
        AxisMessageDispatcher dispatcher = new AxisMessageDispatcher(ep);
        MuleEvent event = SoapActionTemplateTestCase.getTestEvent((Object)"test,");
        String result = dispatcher.parseSoapAction("#[hostInfo]/#[method]", new QName("foo"), event);
        Assert.assertEquals((Object)"http://mycompany.com:8080/foo", (Object)result);
    }

    @Test
    public void testHostReplace() throws Exception {
        OutboundEndpoint ep = muleContext.getEndpointFactory().getOutboundEndpoint("axis:http://mycompany.com:8080/services/myService?method=foo");
        AxisMessageDispatcher dispatcher = new AxisMessageDispatcher(ep);
        MuleEvent event = SoapActionTemplateTestCase.getTestEvent((Object)"test,");
        String name = event.getFlowConstruct().getName();
        String result = dispatcher.parseSoapAction("#[scheme]://#[host]:#[port]/#[serviceName]/#[method]", new QName("foo"), event);
        Assert.assertEquals((Object)("http://mycompany.com:8080/" + name + "/foo"), (Object)result);
    }
}

