/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis.functional;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.message.ds.StringDataSource;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.soap.axis.AxisMessageDispatcher;

public class SoapAttachmentsFunctionalTestCase
extends FunctionalTestCase {
    private static final int SEND_COUNT = 5;
    private int callbackCount = 0;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "axis-soap-attachments.xml";
    }

    @Test
    public void testSend() throws Exception {
        this.sendTestData(5);
        Assert.assertEquals((long)5L, (long)this.callbackCount);
    }

    protected void sendTestData(int iterations) throws Exception {
        OutboundEndpoint ep = muleContext.getRegistry().lookupEndpointBuilder("client").buildOutboundEndpoint();
        AxisMessageDispatcher client = new AxisMessageDispatcher(ep);
        client.initialise();
        for (int i = 0; i < iterations; ++i) {
            DefaultMuleMessage msg = new DefaultMuleMessage((Object)"testPayload", muleContext);
            msg.addOutboundAttachment("testAttachment", new DataHandler((DataSource)new StringDataSource("foo")));
            DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)msg, SoapAttachmentsFunctionalTestCase.getTestInboundEndpoint((String)"test://test"), (FlowConstruct)null);
            MuleMessage result = client.process((MuleEvent)event).getMessage();
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull((Object)result.getPayload());
            Assert.assertEquals((Object)result.getPayloadAsString(), (Object)"Done");
            ++this.callbackCount;
        }
    }
}

