/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis.functional;

import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.NullPayload;

public class WsdlGenerationTestCase
extends FunctionalTestCase {
    private static final String PROXY_REGEX = "^\\$Proxy(\\d+\\d*\\d*)$";
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");
    @Rule
    public DynamicPort dynamicPort3 = new DynamicPort("port3");
    private Map<String, Object> properties;

    protected String getConfigFile() {
        return "axis-wsdl-test.xml";
    }

    @Test
    public void testWsdl1() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort1.getNumber() + "/services/EchoService1?wsdl", this.getTestMuleMessage(NullPayload.getInstance()));
        Assert.assertNotNull((Object)result);
        String wsdl = result.getPayloadAsString();
        Document doc = DocumentHelper.parseText((String)wsdl);
        Assert.assertEquals((Object)"http://foo", (Object)doc.valueOf("/wsdl:definitions/@targetNamespace"));
        Assert.assertTrue((boolean)doc.valueOf("/wsdl:definitions/wsdl:portType/@name").matches(PROXY_REGEX));
        Assert.assertEquals((Object)"http://foo", (Object)doc.valueOf("/wsdl:definitions/wsdl:binding/wsdl:operation[@name='echo']/wsdl:input[@name='echoRequest']/wsdlsoap:body/@namespace"));
        Assert.assertEquals((Object)"http://foo", (Object)doc.valueOf("/wsdl:definitions/wsdl:binding/wsdl:operation[@name='echo']/wsdl:output[@name='echoResponse']/wsdlsoap:body/@namespace"));
        Assert.assertEquals((Object)"EchoService1", (Object)doc.valueOf("/wsdl:definitions/wsdl:service/@name"));
        Assert.assertEquals((Object)"EchoService1", (Object)doc.valueOf("/wsdl:definitions/wsdl:service/wsdl:port/@name"));
        Assert.assertEquals((Object)("http://localhost:" + this.dynamicPort1.getNumber() + "/services/EchoService1"), (Object)doc.valueOf("/wsdl:definitions/wsdl:service/wsdl:port/wsdlsoap:address/@location"));
    }

    @Test
    public void testWsdl2() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort2.getNumber() + "/services/EchoService2?wsdl", this.getTestMuleMessage(NullPayload.getInstance()));
        Assert.assertNotNull((Object)result);
        String wsdl = result.getPayloadAsString();
        Document doc = DocumentHelper.parseText((String)wsdl);
        Assert.assertEquals((Object)"http://simple.component.api.mule.org", (Object)doc.valueOf("/wsdl:definitions/@targetNamespace"));
        Assert.assertEquals((Object)"mulePortType", (Object)doc.valueOf("/wsdl:definitions/wsdl:portType/@name"));
        Assert.assertEquals((Object)"http://simple.component.api.mule.org", (Object)doc.valueOf("/wsdl:definitions/wsdl:binding/wsdl:operation[@name='echo']/wsdl:input[@name='echoRequest']/wsdlsoap:body/@namespace"));
        Assert.assertEquals((Object)"http://simple.component.api.mule.org", (Object)doc.valueOf("/wsdl:definitions/wsdl:binding/wsdl:operation[@name='echo']/wsdl:output[@name='echoResponse']/wsdlsoap:body/@namespace"));
        Assert.assertEquals((Object)"muleService", (Object)doc.valueOf("/wsdl:definitions/wsdl:service/@name"));
        Assert.assertEquals((Object)"muleServicePort", (Object)doc.valueOf("/wsdl:definitions/wsdl:service/wsdl:port/@name"));
        Assert.assertEquals((Object)("http://localhost:" + this.dynamicPort2.getNumber() + "/services/EchoService2"), (Object)doc.valueOf("/wsdl:definitions/wsdl:service/wsdl:port/wsdlsoap:address/@location"));
    }

    @Test
    public void testWsdl3() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort3.getNumber() + "/services/EchoService3?wsdl", this.getTestMuleMessage(NullPayload.getInstance()));
        Assert.assertNotNull((Object)result);
        String wsdl = result.getPayloadAsString();
        Document doc = DocumentHelper.parseText((String)wsdl);
        Assert.assertEquals((Object)"http://foo.com", (Object)doc.valueOf("/wsdl:definitions/@targetNamespace"));
        Assert.assertEquals((Object)"mulePortType1", (Object)doc.valueOf("/wsdl:definitions/wsdl:portType/@name"));
        Assert.assertEquals((Object)"http://foo.com", (Object)doc.valueOf("/wsdl:definitions/wsdl:binding/wsdl:operation[@name='echo']/wsdl:input[@name='echoRequest']/wsdlsoap:body/@namespace"));
        Assert.assertEquals((Object)"http://foo.com", (Object)doc.valueOf("/wsdl:definitions/wsdl:binding/wsdl:operation[@name='echo']/wsdl:output[@name='echoResponse']/wsdlsoap:body/@namespace"));
        Assert.assertEquals((Object)"muleService1", (Object)doc.valueOf("/wsdl:definitions/wsdl:service/@name"));
        Assert.assertEquals((Object)"muleServicePort1", (Object)doc.valueOf("/wsdl:definitions/wsdl:service/wsdl:port/@name"));
        Assert.assertEquals((Object)"http://localhost:62083/services/EchoService3", (Object)doc.valueOf("/wsdl:definitions/wsdl:service/wsdl:port/wsdlsoap:address/@location"));
    }
}

