/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.bpm;

import java.util.Map;
import org.mule.config.ConfigurationException;
import org.mule.config.i18n.MessageFactory;
import org.mule.extras.client.MuleClient;
import org.mule.providers.AbstractConnector;
import org.mule.providers.bpm.BPMS;
import org.mule.providers.bpm.MessageService;
import org.mule.providers.bpm.ProcessMessageReceiver;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.util.StringUtils;

public class ProcessConnector
extends AbstractConnector
implements MessageService {
    protected BPMS bpms;
    protected String processIdField;
    protected boolean allowGlobalReceiver = false;
    protected boolean allowGlobalDispatcher = false;
    public static final String PROPERTY_ENDPOINT = "endpoint";
    public static final String PROPERTY_PROCESS_TYPE = "processType";
    public static final String PROPERTY_PROCESS_ID = "processId";
    public static final String PROPERTY_ACTION = "action";
    public static final String PROPERTY_TRANSITION = "transition";
    public static final String PROPERTY_PROCESS_STARTED = "started";
    public static final String ACTION_START = "start";
    public static final String ACTION_ADVANCE = "advance";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_ABORT = "abort";
    public static final String PROCESS_VARIABLE_INCOMING = "incoming";
    public static final String PROCESS_VARIABLE_INCOMING_SOURCE = "incomingSource";
    public static final String PROCESS_VARIABLE_DATA = "data";
    public static final String PROTOCOL = "bpm";
    public static final String GLOBAL_RECEIVER = "bpm://*";
    private MuleClient muleClient = null;

    public String getProtocol() {
        return PROTOCOL;
    }

    protected void doInitialise() throws InitialisationException {
        try {
            if (this.bpms == null) {
                throw new ConfigurationException(MessageFactory.createStaticMessage((String)"The bpms property must be set for this connector."));
            }
            this.bpms.setMessageService(this);
            if (this.allowGlobalDispatcher && this.muleClient == null) {
                this.muleClient = new MuleClient(this.managementContext);
            }
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }

    public ProcessMessageReceiver lookupReceiver(String processName, Object processId) {
        ProcessMessageReceiver receiver = (ProcessMessageReceiver)this.lookupReceiver(this.toUrl(processName, processId));
        if (receiver == null) {
            receiver = (ProcessMessageReceiver)this.lookupReceiver(this.toUrl(processName, null));
        }
        if (receiver == null) {
            receiver = (ProcessMessageReceiver)this.lookupReceiver(this.toUrl(null, null));
        }
        return receiver;
    }

    public String toUrl(String processName, Object processId) {
        String url = this.getProtocol() + "://";
        if (StringUtils.isNotEmpty((String)processName)) {
            url = url + processName;
            if (processId != null) {
                url = url + "/" + processId;
            }
        } else {
            if (this.isAllowGlobalReceiver()) {
                return GLOBAL_RECEIVER;
            }
            throw new IllegalArgumentException("No valid URL could be created for the given process name and ID: processName = " + processName + ", processId = " + processId);
        }
        return url;
    }

    public UMOMessage generateMessage(String endpoint, Object payloadObject, Map messageProperties, boolean synchronous) throws Exception {
        Object processId;
        String processName = (String)messageProperties.get(PROPERTY_PROCESS_TYPE);
        ProcessMessageReceiver receiver = this.lookupReceiver(processName, processId = messageProperties.get(PROPERTY_PROCESS_ID));
        if (receiver == null) {
            throw new ConfigurationException(MessageFactory.createStaticMessage((String)("No corresponding receiver found for processName = " + processName + ", processId = " + processId)));
        }
        if (synchronous) {
            return receiver.generateSynchronousEvent(endpoint, payloadObject, messageProperties);
        }
        receiver.generateAsynchronousEvent(endpoint, payloadObject, messageProperties);
        return null;
    }

    public BPMS getBpms() {
        return this.bpms;
    }

    public void setBpms(BPMS bpms) {
        this.bpms = bpms;
    }

    public MuleClient getMuleClient() {
        return this.muleClient;
    }

    public boolean isAllowGlobalDispatcher() {
        return this.allowGlobalDispatcher;
    }

    public void setAllowGlobalDispatcher(boolean allowGlobalDispatcher) {
        this.allowGlobalDispatcher = allowGlobalDispatcher;
    }

    public boolean isAllowGlobalReceiver() {
        return this.allowGlobalReceiver;
    }

    public void setAllowGlobalReceiver(boolean allowGlobalReceiver) {
        this.allowGlobalReceiver = allowGlobalReceiver;
    }

    public String getProcessIdField() {
        return this.processIdField;
    }

    public void setProcessIdField(String processIdField) {
        this.processIdField = processIdField;
    }
}

