/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.bpm;

import java.util.HashMap;
import java.util.Iterator;
import org.mule.config.i18n.MessageFactory;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.NullPayload;
import org.mule.providers.bpm.ProcessConnector;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.util.StringUtils;

public class ProcessMessageDispatcher
extends AbstractMessageDispatcher {
    private ProcessConnector connector;

    public ProcessMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (ProcessConnector)endpoint.getConnector();
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        Object process = this.processAction(event);
        if (process != null) {
            MuleMessage msg = new MuleMessage(process);
            msg.setProperty("processId", this.connector.getBpms().getId(process));
            return msg;
        }
        throw new DispatchException(MessageFactory.createStaticMessage((String)"Synchronous process invocation must return the new process state."), event.getMessage(), event.getEndpoint());
    }

    public void doDispatch(UMOEvent event) throws Exception {
        this.processAction(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object processAction(UMOEvent event) throws Exception {
        Object processId;
        Object process = null;
        HashMap<String, Object> processVariables = new HashMap<String, Object>();
        if (event != null) {
            Iterator iterator = event.getMessage().getPropertyNames().iterator();
            while (iterator.hasNext()) {
                String propertyName = (String)iterator.next();
                processVariables.put(propertyName, event.getMessage().getProperty(propertyName));
            }
            Object payload = event.getTransformedMessage();
            if (payload != null && !(payload instanceof NullPayload)) {
                processVariables.put("incoming", payload);
                String originatingEndpoint = event.getMessage().getStringProperty("MULE_ORIGINATING_ENDPOINT", null);
                if (StringUtils.isNotEmpty((String)originatingEndpoint)) {
                    processVariables.put("incomingSource", originatingEndpoint);
                }
            }
        }
        Object processType = event.getProperty("processType", true);
        processVariables.remove("processType");
        String processIdField = this.connector.getProcessIdField();
        if (StringUtils.isNotEmpty((String)processIdField)) {
            processId = event.getProperty(processIdField, false);
        }
        processId = event.getProperty("processId", true);
        processVariables.remove("processId");
        String action = event.getMessage().getStringProperty("action", "advance");
        processVariables.remove("action");
        Object transition = event.getMessage().getProperty("transition");
        processVariables.remove("transition");
        String temp = event.getEndpoint().getEndpointURI().getHost();
        if (StringUtils.isNotEmpty((String)temp)) {
            processType = temp;
        }
        if (StringUtils.isNotEmpty((String)(temp = event.getEndpoint().getEndpointURI().getPath()))) {
            if (temp.startsWith("/")) {
                temp = StringUtils.right((String)temp, (int)(temp.length() - 1));
            }
            if (temp.indexOf("/") != -1) {
                throw new IllegalArgumentException("Unexpected format in the path of the URL: " + temp);
            }
            processId = temp;
        }
        if (processId == null || action.equals("start")) {
            if (processType == null) throw new IllegalArgumentException("Process type is missing, cannot start a new process.");
            process = this.connector.getBpms().startProcess(processType, transition, processVariables);
            if (process == null || !this.logger.isInfoEnabled()) return process;
            this.logger.info((Object)("New process started, ID = " + this.connector.getBpms().getId(process)));
            return process;
        } else if (action.equals("update")) {
            if (processId == null) throw new IllegalArgumentException("Process ID is missing, cannot update process.");
            process = this.connector.getBpms().updateProcess(processId, processVariables);
            if (process == null || !this.logger.isInfoEnabled()) return process;
            this.logger.info((Object)("Process variables updated, ID = " + this.connector.getBpms().getId(process)));
            return process;
        } else if (action.equals("abort")) {
            if (processId == null) throw new IllegalArgumentException("Process ID is missing, cannot abort process.");
            this.connector.getBpms().abortProcess(processId);
            process = NullPayload.getInstance();
            this.logger.info((Object)("Process aborted, ID = " + processId));
            return process;
        } else {
            if (processId == null) throw new IllegalArgumentException("Process ID is missing, cannot advance process.");
            process = this.connector.getBpms().advanceProcess(processId, transition, processVariables);
            if (process == null || !this.logger.isInfoEnabled()) return process;
            this.logger.info((Object)("Process advanced, ID = " + this.connector.getBpms().getId(process) + ", new state = " + this.connector.getBpms().getState(process)));
        }
        return process;
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }
}

